/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.xnio.nio;

import java.io.Closeable;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Bits;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelListeners;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoUtils;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.nio.NioHandle;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.nio.NioUdpChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.nio.WorkerThread;

final class NioUdpChannelHandle
extends NioHandle {
    private final NioUdpChannel channel;

    NioUdpChannelHandle(WorkerThread workerThread, SelectionKey selectionKey, NioUdpChannel channel) {
        super(workerThread, selectionKey);
        this.channel = channel;
    }

    @Override
    void handleReady(int ops) {
        try {
            if (ops == 0) {
                SelectionKey key = this.getSelectionKey();
                int interestOps = key.interestOps();
                if (interestOps != 0) {
                    ops = interestOps;
                } else {
                    this.forceTermination();
                    return;
                }
            }
            if (Bits.allAreSet(ops, 1)) {
                try {
                    ChannelListeners.invokeChannelListener(this.channel, this.channel.getReadListener());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (Bits.allAreSet(ops, 4)) {
                try {
                    ChannelListeners.invokeChannelListener(this.channel, this.channel.getWriteListener());
                }
                catch (Throwable throwable) {}
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    @Override
    void forceTermination() {
        IoUtils.safeClose((Closeable)this.channel);
    }

    @Override
    void terminated() {
        this.channel.invokeCloseHandler();
    }
}

