/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.xnio.ssl;

import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Bits;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelListener;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelListeners;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoUtils;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Option;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Options;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Pool;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.SslClientAuthMode;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.StreamConnection;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.ConduitStreamSinkChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.ConduitStreamSourceChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.StreamSinkConduit;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.StreamSourceConduit;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ssl.JsseSslConduitEngine;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ssl.JsseSslStreamSinkConduit;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ssl.JsseSslStreamSourceConduit;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ssl.JsseXnioSsl;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ssl.SslConnection;

public final class JsseSslStreamConnection
extends SslConnection {
    private final StreamConnection connection;
    private final JsseSslConduitEngine sslConduitEngine;
    private volatile boolean tls;
    private final ChannelListener.SimpleSetter<SslConnection> handshakeSetter = new ChannelListener.SimpleSetter();
    private volatile int state;
    private static final int FLAG_READ_CLOSE_REQUESTED = 1;
    private static final int FLAG_WRITE_CLOSE_REQUESTED = 2;
    private static final int FLAG_READ_CLOSED = 4;
    private static final int FLAG_WRITE_CLOSED = 8;
    private static final AtomicIntegerFieldUpdater<JsseSslStreamConnection> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(JsseSslStreamConnection.class, "state");
    private static final Set<Option<?>> SUPPORTED_OPTIONS = Option.setBuilder().add((Option<?>)Options.SECURE, (Option<?>)Options.SSL_CLIENT_AUTH_MODE).create();

    public JsseSslStreamConnection(StreamConnection connection, SSLEngine sslEngine, boolean startTls) {
        this(connection, sslEngine, JsseXnioSsl.bufferPool, JsseXnioSsl.bufferPool, startTls);
    }

    JsseSslStreamConnection(StreamConnection connection, SSLEngine sslEngine, Pool<ByteBuffer> socketBufferPool, Pool<ByteBuffer> applicationBufferPool, boolean startTls) {
        super(connection.getIoThread());
        this.connection = connection;
        StreamSinkConduit sinkConduit = connection.getSinkChannel().getConduit();
        StreamSourceConduit sourceConduit = connection.getSourceChannel().getConduit();
        this.sslConduitEngine = new JsseSslConduitEngine(this, sinkConduit, sourceConduit, sslEngine, socketBufferPool, applicationBufferPool);
        this.tls = !startTls;
        this.setSinkConduit(new JsseSslStreamSinkConduit(sinkConduit, this.sslConduitEngine, this.tls));
        this.setSourceConduit(new JsseSslStreamSourceConduit(sourceConduit, this.sslConduitEngine, this.tls));
        this.getSourceChannel().setCloseListener((ChannelListener<? super ConduitStreamSourceChannel>)((ChannelListener<ConduitStreamSourceChannel>)channel -> this.readClosed()));
        this.getSinkChannel().setCloseListener((ChannelListener<? super ConduitStreamSinkChannel>)((ChannelListener<ConduitStreamSinkChannel>)channel -> this.writeClosed()));
    }

    @Override
    public synchronized void startHandshake() throws IOException {
        if (!this.tls) {
            this.tls = true;
            ((JsseSslStreamSourceConduit)this.getSourceChannel().getConduit()).enableTls();
            ((JsseSslStreamSinkConduit)this.getSinkChannel().getConduit()).enableTls();
        }
        this.sslConduitEngine.beginHandshake();
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.connection.getPeerAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.connection.getLocalAddress();
    }

    @Override
    protected void closeAction() throws IOException {
        if (!this.sslConduitEngine.isClosed()) {
            this.sslConduitEngine.close();
        } else {
            if (this.tls) {
                try {
                    this.getSinkChannel().getConduit().terminateWrites();
                }
                catch (IOException e) {
                    try {
                        this.getSourceChannel().getConduit().terminateReads();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    IoUtils.safeClose((Closeable)this.connection);
                    throw e;
                }
                try {
                    this.getSourceChannel().getConduit().terminateReads();
                }
                catch (IOException e) {
                    IoUtils.safeClose((Closeable)this.connection);
                    throw e;
                }
                super.closeAction();
            }
            this.connection.close();
        }
    }

    @Override
    protected void notifyWriteClosed() {
    }

    @Override
    protected void notifyReadClosed() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        if (option == Options.SSL_CLIENT_AUTH_MODE) {
            T t2;
            SSLEngine engine = this.sslConduitEngine.getEngine();
            try {
                t2 = option.cast((Object)(engine.getNeedClientAuth() ? SslClientAuthMode.REQUIRED : (engine.getWantClientAuth() ? SslClientAuthMode.REQUESTED : SslClientAuthMode.NOT_REQUESTED)));
                engine.setNeedClientAuth(value == SslClientAuthMode.REQUIRED);
                engine.setWantClientAuth(value == SslClientAuthMode.REQUESTED);
            }
            catch (Throwable throwable) {
                engine.setNeedClientAuth(value == SslClientAuthMode.REQUIRED);
                engine.setWantClientAuth(value == SslClientAuthMode.REQUESTED);
                throw throwable;
            }
            return t2;
        }
        if (option == Options.SECURE) {
            throw new IllegalArgumentException();
        }
        return this.connection.setOption(option, value);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        if (option == Options.SSL_CLIENT_AUTH_MODE) {
            SSLEngine engine = this.sslConduitEngine.getEngine();
            return option.cast((Object)(engine.getNeedClientAuth() ? SslClientAuthMode.REQUIRED : (engine.getWantClientAuth() ? SslClientAuthMode.REQUESTED : SslClientAuthMode.NOT_REQUESTED)));
        }
        return option == Options.SECURE ? option.cast(this.tls) : this.connection.getOption(option);
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return SUPPORTED_OPTIONS.contains(option) || this.connection.supportsOption(option);
    }

    @Override
    public SSLSession getSslSession() {
        return this.tls ? this.sslConduitEngine.getSession() : null;
    }

    @Override
    public ChannelListener.Setter<? extends SslConnection> getHandshakeSetter() {
        return this.handshakeSetter;
    }

    SSLEngine getEngine() {
        return this.sslConduitEngine.getEngine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean readClosed() {
        boolean closeRequestedNow;
        JsseSslStreamConnection jsseSslStreamConnection = this;
        synchronized (jsseSslStreamConnection) {
            int newVal;
            int oldVal;
            while (!Bits.allAreSet(oldVal = this.state, 1) && !stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 1)) {
            }
            closeRequestedNow = Bits.allAreSet(oldVal, 1);
            if (this.sslConduitEngine.isClosed() || !this.tls) {
                do {
                    if (!Bits.allAreSet(oldVal = this.state, 4)) continue;
                    return false;
                } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 4));
                if (Bits.allAreSet(oldVal, 4)) {
                    return false;
                }
            } else {
                return closeRequestedNow;
            }
        }
        super.readClosed();
        return closeRequestedNow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean writeClosed() {
        boolean closeRequestedNow;
        JsseSslStreamConnection jsseSslStreamConnection = this;
        synchronized (jsseSslStreamConnection) {
            int newVal;
            int oldVal;
            while (!Bits.allAreSet(oldVal = this.state, 2) && !stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 2)) {
            }
            closeRequestedNow = Bits.allAreSet(oldVal, 2);
            if (this.sslConduitEngine.isClosed() || !this.tls) {
                do {
                    if (!Bits.allAreSet(oldVal = this.state, 8)) continue;
                    return false;
                } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 8));
                if (Bits.allAreSet(oldVal, 8)) {
                    return false;
                }
            } else {
                return closeRequestedNow;
            }
        }
        super.writeClosed();
        return closeRequestedNow;
    }

    protected void handleHandshakeFinished() {
        ChannelListener<SslConnection> listener = this.handshakeSetter.get();
        if (listener == null) {
            return;
        }
        ChannelListeners.invokeChannelListener(this, listener);
    }

    @Override
    public boolean isReadShutdown() {
        return Bits.allAreSet(this.state, 1);
    }

    @Override
    public boolean isWriteShutdown() {
        return Bits.allAreSet(this.state, 2);
    }
}

