/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.xnio.streams;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Buffers;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Pooled;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Xnio;
import net.thisptr.jmx.exporter.agent.shade.org.xnio._private.Messages;

public class BufferPipeInputStream
extends InputStream {
    private final Queue<Pooled<ByteBuffer>> queue;
    private final InputHandler inputHandler;
    private boolean eof;
    private IOException failure;

    public BufferPipeInputStream(InputHandler inputHandler) {
        this.inputHandler = inputHandler;
        this.queue = new ArrayDeque<Pooled<ByteBuffer>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(ByteBuffer buffer) {
        BufferPipeInputStream bufferPipeInputStream = this;
        synchronized (bufferPipeInputStream) {
            if (buffer.hasRemaining() && !this.eof && this.failure == null) {
                this.queue.add(Buffers.pooledWrapper(buffer));
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Pooled<ByteBuffer> pooledBuffer) {
        BufferPipeInputStream bufferPipeInputStream = this;
        synchronized (bufferPipeInputStream) {
            if (pooledBuffer.getResource().hasRemaining() && !this.eof && this.failure == null) {
                this.queue.add(pooledBuffer);
                this.notifyAll();
            } else {
                pooledBuffer.free();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushException(IOException e) {
        BufferPipeInputStream bufferPipeInputStream = this;
        synchronized (bufferPipeInputStream) {
            if (!this.eof) {
                this.failure = e;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushEof() {
        BufferPipeInputStream bufferPipeInputStream = this;
        synchronized (bufferPipeInputStream) {
            this.eof = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Queue<Pooled<ByteBuffer>> queue = this.queue;
        BufferPipeInputStream bufferPipeInputStream = this;
        synchronized (bufferPipeInputStream) {
            while (queue.isEmpty()) {
                if (this.eof) {
                    return -1;
                }
                this.checkFailure();
                Xnio.checkBlockingAllowed();
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Messages.msg.interruptedIO();
                }
            }
            Pooled<ByteBuffer> entry = queue.peek();
            ByteBuffer buf = entry.getResource();
            int v = buf.get() & 0xFF;
            if (buf.remaining() == 0) {
                queue.poll();
                try {
                    this.inputHandler.acknowledge(entry);
                }
                catch (IOException iOException) {
                }
                finally {
                    entry.free();
                }
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearQueue() {
        BufferPipeInputStream bufferPipeInputStream = this;
        synchronized (bufferPipeInputStream) {
            Pooled<ByteBuffer> entry;
            while ((entry = this.queue.poll()) != null) {
                entry.free();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        Queue<Pooled<ByteBuffer>> queue = this.queue;
        BufferPipeInputStream bufferPipeInputStream = this;
        synchronized (bufferPipeInputStream) {
            Pooled<ByteBuffer> entry;
            while (queue.isEmpty()) {
                if (this.eof) {
                    return -1;
                }
                this.checkFailure();
                Xnio.checkBlockingAllowed();
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Messages.msg.interruptedIO();
                }
            }
            int total = 0;
            while (len > 0 && (entry = queue.peek()) != null) {
                ByteBuffer buffer = entry.getResource();
                int byteCnt = Math.min(buffer.remaining(), len);
                buffer.get(b, off, byteCnt);
                off += byteCnt;
                total += byteCnt;
                len -= byteCnt;
                if (buffer.remaining() != 0) continue;
                queue.poll();
                try {
                    this.inputHandler.acknowledge(entry);
                }
                catch (IOException iOException) {}
                continue;
                finally {
                    entry.free();
                }
            }
            return total;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        BufferPipeInputStream bufferPipeInputStream = this;
        synchronized (bufferPipeInputStream) {
            int total = 0;
            for (Pooled pooled : this.queue) {
                if ((total += ((ByteBuffer)pooled.getResource()).remaining()) >= 0) continue;
                return Integer.MAX_VALUE;
            }
            return total;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long qty) throws IOException {
        Queue<Pooled<ByteBuffer>> queue = this.queue;
        BufferPipeInputStream bufferPipeInputStream = this;
        synchronized (bufferPipeInputStream) {
            Pooled<ByteBuffer> entry;
            while (queue.isEmpty()) {
                if (this.eof) {
                    return 0L;
                }
                this.checkFailure();
                Xnio.checkBlockingAllowed();
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Messages.msg.interruptedIO();
                }
            }
            long skipped = 0L;
            while (qty > 0L && (entry = queue.peek()) != null) {
                ByteBuffer buffer = entry.getResource();
                int byteCnt = (int)Math.min((long)buffer.remaining(), Math.max(Integer.MAX_VALUE, qty));
                buffer.position(buffer.position() + byteCnt);
                skipped += (long)byteCnt;
                qty -= (long)byteCnt;
                if (buffer.remaining() != 0) continue;
                queue.poll();
                try {
                    this.inputHandler.acknowledge(entry);
                }
                catch (IOException iOException) {}
                continue;
                finally {
                    entry.free();
                }
            }
            return skipped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        BufferPipeInputStream bufferPipeInputStream = this;
        synchronized (bufferPipeInputStream) {
            if (!this.eof) {
                this.clearQueue();
                this.eof = true;
                this.failure = null;
                this.notifyAll();
                this.inputHandler.close();
            }
        }
    }

    private void checkFailure() throws IOException {
        assert (Thread.holdsLock(this));
        IOException failure = this.failure;
        if (failure != null) {
            failure.fillInStackTrace();
            try {
                throw failure;
            }
            catch (Throwable throwable) {
                this.clearQueue();
                this.notifyAll();
                throw throwable;
            }
        }
    }

    public static interface InputHandler
    extends Closeable {
        public void acknowledge(Pooled<ByteBuffer> var1) throws IOException;

        @Override
        public void close() throws IOException;
    }
}

