/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.xnio.streams;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public final class LimitedOutputStream
extends OutputStream {
    private final OutputStream delegate;
    private long remaining;

    public LimitedOutputStream(OutputStream delegate, long size) {
        this.delegate = delegate;
        this.remaining = size;
    }

    @Override
    public void write(int b) throws IOException {
        long remaining = this.remaining;
        if (remaining < 1L) {
            throw LimitedOutputStream.notEnoughSpace();
        }
        this.delegate.write(b);
        this.remaining = remaining - 1L;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        long remaining = this.remaining;
        if (remaining < (long)len) {
            throw LimitedOutputStream.notEnoughSpace();
        }
        try {
            this.delegate.write(b, off, len);
            this.remaining = remaining - (long)len;
        }
        catch (InterruptedIOException e) {
            this.remaining = remaining - ((long)e.bytesTransferred & 0xFFFFFFFFL);
            throw e;
        }
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    private static IOException notEnoughSpace() {
        return new IOException("Not enough space in output stream");
    }
}

