/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.utils;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class MoreCollections {
    public static <T> void forEachSlowlyOverDuration(Collection<T> elements, long duration, TimeUnit unit, Consumer<T> fn) throws InterruptedException {
        long startNanos = System.nanoTime();
        long durationNanos = unit.toNanos(duration);
        Iterator<T> iter = elements.iterator();
        for (int i = 0; i < elements.size(); ++i) {
            long waitUntilNanos = startNanos + (long)((double)(i + 1) / (double)elements.size() * (double)durationNanos);
            long sleepNanos = waitUntilNanos - System.nanoTime();
            if (sleepNanos > 10000000L) {
                MoreCollections.sleepNanos(sleepNanos);
            }
            fn.accept(iter.next());
        }
        long waitUntilNanos = startNanos + durationNanos;
        long sleepNanos = waitUntilNanos - System.nanoTime();
        if (sleepNanos > 0L) {
            MoreCollections.sleepNanos(sleepNanos);
        }
    }

    private static void sleepNanos(long totalNanos) throws InterruptedException {
        int nanos = (int)(totalNanos % 1000000L);
        long millis = totalNanos / 1000000L;
        Thread.sleep(millis, nanos);
    }
}

