/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.writer;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import net.thisptr.jmx.exporter.agent.misc.StringWriter;
import net.thisptr.jmx.exporter.agent.scripting.PrometheusMetric;
import net.thisptr.jmx.exporter.agent.utils.MoreLongs;
import net.thisptr.jmx.exporter.agent.writer.SanitizingStringWriter;

public class PrometheusMetricWriter
implements Closeable {
    private final boolean includeTimestamp;
    private ByteBuffer buf;
    private byte[] bytes;
    private int position;
    private final WritableByteChannel channel;
    private final WritableByteChannelController controller;
    private static final byte[] HELP = "HELP".getBytes(StandardCharsets.UTF_8);
    private static final byte[] TYPE = "TYPE".getBytes(StandardCharsets.UTF_8);

    public PrometheusMetricWriter(WritableByteChannel channel, WritableByteChannelController controller, ByteBuffer buf, boolean includeTimestamp) {
        if (!buf.hasArray()) {
            throw new IllegalArgumentException("buf must be an array-backed ByteBuffer");
        }
        this.channel = channel;
        this.controller = controller;
        this.buf = buf;
        this.bytes = buf.array();
        this.position = 0;
        this.includeTimestamp = includeTimestamp;
    }

    private void flush() throws IOException {
        this.buf.position(0);
        this.buf.limit(this.position);
        while (true) {
            this.channel.write(this.buf);
            if (!this.buf.hasRemaining()) break;
            this.controller.awaitWritable();
        }
    }

    private int ensureAtLeast(int length) throws IOException {
        byte[] bytes = this.bytes;
        int index = this.position;
        if (bytes.length - index < length) {
            this.flush();
            this.position = 0;
            if (bytes.length < length) {
                this.buf = ByteBuffer.allocate(length);
                this.bytes = this.buf.array();
                return 0;
            }
            return 0;
        }
        return index;
    }

    private static int sanitizeLabelName(byte[] bytes, int index, String name) {
        if (name.isEmpty()) {
            bytes[index++] = 95;
            return index;
        }
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            boolean valid;
            char ch = name.charAt(i);
            boolean bl = valid = 'a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9' && i != 0 || ch == '_';
            if (valid) {
                bytes[index++] = (byte)ch;
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                ++i;
            }
            bytes[index++] = 95;
        }
        return index;
    }

    private static int sanitizeSuffix(byte[] bytes, int index, String name) {
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char ch = name.charAt(i);
            if ('a' <= ch && ch <= 'z' || ch == '_' || ch == ':' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9') {
                bytes[index++] = (byte)ch;
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                ++i;
            }
            bytes[index++] = 95;
        }
        return index;
    }

    public void write(PrometheusMetric metric) throws IOException {
        if (metric.nameWriter != null) {
            this.ensureAtLeast(metric.nameWriter.expectedSize(metric.name) + 1);
            this.position = metric.nameWriter.write(metric.name, this.bytes, this.position);
        } else {
            this.ensureAtLeast(SanitizingStringWriter.getInstance().expectedSize(metric.name) + 1);
            this.position = SanitizingStringWriter.getInstance().write(metric.name, this.bytes, this.position);
        }
        if (metric.suffix != null && !metric.suffix.isEmpty()) {
            this.ensureAtLeast(1 + metric.suffix.length() + 1);
            this.bytes[this.position++] = 95;
            this.position = PrometheusMetricWriter.sanitizeSuffix(this.bytes, this.position, metric.suffix);
        }
        if (metric.labels != null && !metric.labels.isEmpty()) {
            this.bytes[this.position++] = 123;
            metric.labels.forEach((labelName, labelValue) -> {
                int size = 2 + Math.max(1, labelName.length()) + (labelValue != null ? 2 + labelValue.length() * 3 : 6) + 1;
                try {
                    this.ensureAtLeast(size);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                int index = this.position;
                index = PrometheusMetricWriter.sanitizeLabelName(this.bytes, index, labelName);
                this.bytes[index++] = 61;
                index = PrometheusMetricWriter.sanitizeLabelValue(this.bytes, index, labelValue);
                this.bytes[index++] = 44;
                this.position = index;
            });
            this.bytes[this.position++] = 125;
        }
        if (metric.value == (double)((long)metric.value)) {
            this.ensureAtLeast(22);
            this.bytes[this.position++] = 32;
            this.position = MoreLongs.writeAsString((long)metric.value, this.bytes, this.position);
        } else {
            String valueText = String.valueOf(metric.value);
            this.ensureAtLeast(1 + valueText.length() + 1);
            this.bytes[this.position++] = 32;
            this.position = PrometheusMetricWriter.writeTextUtf8(this.bytes, this.position, valueText);
        }
        if (this.includeTimestamp && metric.timestamp != 0L) {
            this.ensureAtLeast(22);
            this.bytes[this.position++] = 32;
            this.position = MoreLongs.writeAsString(metric.timestamp, this.bytes, this.position);
        }
        this.bytes[this.position++] = 10;
    }

    private static int sanitizeLabelValue(byte[] bytes, int index, String text) {
        bytes[index++] = 34;
        if (text == null) {
            bytes[index++] = 110;
            bytes[index++] = 117;
            bytes[index++] = 108;
            bytes[index++] = 108;
        } else {
            index = PrometheusMetricWriter.writeTextUtf8Escaped(bytes, index, text, true);
        }
        bytes[index++] = 34;
        return index;
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    private static int writeTextUtf8(byte[] bytes, int index, String text) throws IOException {
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch < '\u0080') {
                bytes[index++] = (byte)ch;
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                int codePoint = Character.toCodePoint(ch, text.charAt(++i));
                index = PrometheusMetricWriter.writeUnicode(bytes, index, codePoint);
                continue;
            }
            index = PrometheusMetricWriter.writeUnicode(bytes, index, ch);
        }
        return index;
    }

    private static int writeTextUtf8Escaped(byte[] bytes, int index, String text, boolean escapeDoubleQuotes) {
        int length = text.length();
        block5: for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\\': {
                    bytes[index++] = 92;
                    bytes[index++] = 92;
                    continue block5;
                }
                case '\n': {
                    bytes[index++] = 92;
                    bytes[index++] = 110;
                    continue block5;
                }
                case '\"': {
                    if (escapeDoubleQuotes) {
                        bytes[index++] = 92;
                    }
                    bytes[index++] = 34;
                    continue block5;
                }
                default: {
                    if (Character.isHighSurrogate(ch)) {
                        int codePoint = Character.toCodePoint(ch, text.charAt(++i));
                        index = PrometheusMetricWriter.writeUnicode(bytes, index, codePoint);
                        continue block5;
                    }
                    index = PrometheusMetricWriter.writeUnicode(bytes, index, ch);
                }
            }
        }
        return index;
    }

    private void writeAnnotation(String metricName, StringWriter writer, String nameSuffix, byte[] annotationType, String value) throws IOException {
        int size = 5 + annotationType.length + (writer != null ? writer.expectedSize(metricName) : SanitizingStringWriter.getInstance().expectedSize(metricName)) + (nameSuffix != null && !nameSuffix.isEmpty() ? 1 + nameSuffix.length() : 0) + value.length() * 3;
        this.ensureAtLeast(size);
        int index = this.position;
        this.bytes[index++] = 35;
        this.bytes[index++] = 32;
        for (int i = 0; i < annotationType.length; ++i) {
            this.bytes[index++] = annotationType[i];
        }
        this.bytes[index++] = 32;
        index = writer != null ? writer.write(metricName, this.bytes, index) : SanitizingStringWriter.getInstance().write(metricName, this.bytes, index);
        if (nameSuffix != null && !nameSuffix.isEmpty()) {
            this.bytes[index++] = 95;
            index = PrometheusMetricWriter.sanitizeSuffix(this.bytes, index, nameSuffix);
        }
        this.bytes[index++] = 32;
        index = PrometheusMetricWriter.writeTextUtf8Escaped(this.bytes, index, value, false);
        this.bytes[index++] = 10;
        this.position = index;
    }

    public void writeHelp(String name, StringWriter writer, String nameSuffix, String helpText) throws IOException {
        this.writeAnnotation(name, writer, nameSuffix, HELP, helpText);
    }

    public void writeType(String name, StringWriter writer, String nameSuffix, String typeText) throws IOException {
        this.writeAnnotation(name, writer, nameSuffix, TYPE, typeText);
    }

    private static int writeUnicode(byte[] bytes, int index, int codePoint) {
        if (codePoint < 128) {
            bytes[index++] = (byte)codePoint;
        } else if (codePoint < 2048) {
            bytes[index++] = (byte)(0xC0 | codePoint >>> 6);
            bytes[index++] = (byte)(0x80 | codePoint >>> 0 & 0x3F);
        } else if (codePoint < 65536) {
            bytes[index++] = (byte)(0xE0 | codePoint >>> 12);
            bytes[index++] = (byte)(0x80 | codePoint >>> 6 & 0x3F);
            bytes[index++] = (byte)(0x80 | codePoint >>> 0 & 0x3F);
        } else if (codePoint < 0x110000) {
            bytes[index++] = (byte)(0xF0 | codePoint >>> 18);
            bytes[index++] = (byte)(0x80 | codePoint >>> 12 & 0x3F);
            bytes[index++] = (byte)(0x80 | codePoint >>> 6 & 0x3F);
            bytes[index++] = (byte)(0x80 | codePoint >>> 0 & 0x3F);
        } else {
            throw new IllegalArgumentException("invalid codepoint: " + codePoint);
        }
        return index;
    }

    public static interface WritableByteChannelController {
        public void awaitWritable() throws IOException;
    }
}

