/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.matchers;

import net.thucydides.core.matchers.DateMatcherFormatter;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class DateTimeIsBetweenMatcher
extends TypeSafeMatcher<DateTime> {
    private final DateTime startDate;
    private final DateTime endDate;

    public DateTimeIsBetweenMatcher(DateTime startDate, DateTime endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public boolean matchesSafely(DateTime provided) {
        return !(!provided.isEqual((ReadableInstant)this.startDate) && !provided.isAfter((ReadableInstant)this.startDate) || !provided.isEqual((ReadableInstant)this.endDate) && !provided.isBefore((ReadableInstant)this.endDate));
    }

    public void describeTo(Description description) {
        description.appendText("a date that is between ");
        description.appendText(DateMatcherFormatter.formatted(this.startDate));
        description.appendText(" and ");
        description.appendText(DateMatcherFormatter.formatted(this.endDate));
    }
}

