/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages.jquery;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import net.thucydides.core.pages.JavaScriptExecutorFacade;
import org.openqa.selenium.WebDriver;

public class JQueryEnabledPage {
    private final WebDriver driver;

    public JQueryEnabledPage(WebDriver driver) {
        this.driver = driver;
    }

    public static JQueryEnabledPage withDriver(WebDriver driver) {
        return new JQueryEnabledPage(driver);
    }

    public boolean containsJQuery() {
        JavaScriptExecutorFacade js = new JavaScriptExecutorFacade(this.driver);
        return (Boolean)js.executeScript("return (typeof jQuery === 'function')");
    }

    public void injectJQuery() {
        String jquery = this.getFileAsString("jquery/jquery.min.js");
        JavaScriptExecutorFacade js = new JavaScriptExecutorFacade(this.driver);
        js.executeScript(jquery);
    }

    private String getFileAsString(String resourcePath) {
        String content = "";
        try {
            URL fileUrl = this.getClass().getClassLoader().getResource(resourcePath);
            content = Resources.toString((URL)fileUrl, (Charset)Charsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        return content;
    }

    public static boolean scriptContainsJQuery(String script) {
        return script.contains("$(") || script.toLowerCase().contains("jquery(");
    }
}

