/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html.history;

import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class TestResultSnapshot
implements Comparable<TestResultSnapshot> {
    private final DateTime time;
    private final int specifiedSteps;
    private final int passingSteps;
    private final int failingSteps;
    private final int skippedSteps;
    private final String buildId;

    public TestResultSnapshot(DateTime time, int specifiedSteps, int passingSteps, int failingSteps, int skippedSteps, String buildId) {
        this.time = time;
        this.specifiedSteps = specifiedSteps;
        this.passingSteps = passingSteps;
        this.failingSteps = failingSteps;
        this.skippedSteps = skippedSteps;
        this.buildId = buildId;
    }

    public TestResultSnapshot(int specifiedSteps, int passingSteps, int failingSteps, int skippedSteps, String buildId) {
        this(DateTime.now(), specifiedSteps, passingSteps, failingSteps, skippedSteps, buildId);
    }

    public DateTime getTime() {
        return this.time;
    }

    public int getSpecifiedSteps() {
        return this.specifiedSteps;
    }

    public int getPassingSteps() {
        return this.passingSteps;
    }

    public int getFailingSteps() {
        return this.failingSteps;
    }

    public int getSkippedSteps() {
        return this.skippedSteps;
    }

    public String getBuildId() {
        return this.buildId;
    }

    @Override
    public int compareTo(TestResultSnapshot other) {
        if (this == other) {
            return 0;
        }
        return this.getTime().compareTo((ReadableInstant)other.getTime());
    }
}

