/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html.screenshots;

import java.io.File;
import java.io.IOException;
import net.thucydides.core.images.ResizableImage;
import net.thucydides.core.model.Screenshot;

public class ScreenshotFormatter {
    private final Screenshot screenshot;
    private final File sourceDirectory;

    private ScreenshotFormatter(Screenshot screenshot, File sourceDirectory) {
        this.screenshot = screenshot;
        this.sourceDirectory = sourceDirectory;
    }

    public static ScreenshotFormatter forScreenshot(Screenshot screenshot) {
        return new ScreenshotFormatter(screenshot, null);
    }

    public ScreenshotFormatter inDirectory(File sourceDirectory) {
        return new ScreenshotFormatter(this.screenshot, sourceDirectory);
    }

    public Screenshot expandToHeight(int targetHeight) throws IOException {
        File screenshotFile = new File(this.sourceDirectory, this.screenshot.getFilename());
        if (screenshotFile.exists()) {
            File resizedFile = this.resizedImage(screenshotFile, targetHeight);
            return new Screenshot(resizedFile.getName(), this.screenshot.getDescription(), this.screenshot.getWidth(), this.screenshot.getError());
        }
        return this.screenshot;
    }

    private File resizedImage(File screenshotFile, int maxHeight) throws IOException {
        ResizableImage scaledImage = ResizableImage.loadFrom(screenshotFile).rescaleCanvas(maxHeight);
        File scaledFile = new File(this.sourceDirectory, "scaled_" + screenshotFile.getName());
        scaledImage.saveTo(scaledFile);
        return scaledFile;
    }
}

