/*
 * Decompiled with CFR 0.152.
 */
package net.tislib.websiteparser.engine;

import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import net.tislib.websiteparser.annotations.HtmlParserContext;
import net.tislib.websiteparser.annotations.RegexSupportsParser;
import net.tislib.websiteparser.annotations.generic.ImportedEntity;
import net.tislib.websiteparser.annotations.generic.SourceInfo;
import net.tislib.websiteparser.engine.BeanProcessor;
import net.tislib.websiteparser.engine.PageData;
import net.tislib.websiteparser.engine.ParserRegistry;
import net.tislib.websiteparser.engine.context.HtmlDocumentParser;
import net.tislib.websiteparser.engine.parsers.BeanFieldsParser;
import net.tislib.websiteparser.engine.parsers.BeanMethodsParser;

public class EntityParser<T> {
    private final Validator validator;
    private final Class<T> entityClass;
    private final BeanProcessor beanProcessor;
    private final Predicate<PageData> supportsFunction;
    private final ParserRegistry parserRegistry;

    public EntityParser(Class<T> entityClass) {
        this(null, entityClass);
    }

    public EntityParser(ParserRegistry registry, Class<T> entityClass) {
        this.entityClass = entityClass;
        this.beanProcessor = new BeanProcessor();
        this.parserRegistry = registry;
        this.supportsFunction = EntityParser.prepareSupportsFunction(entityClass);
        this.prepareProcessors();
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        this.validator = factory.getValidator();
    }

    private static Predicate<PageData> checkRegexSupports(RegexSupportsParser regexSupportsParser) {
        Predicate<String> regexPredicate = Pattern.compile(regexSupportsParser.pattern()).asPredicate();
        switch (regexSupportsParser.source()) {
            case URL: {
                return pageData -> pageData.getUrl() != null && regexPredicate.test(pageData.getUrl());
            }
            case CONTENT: {
                return pageData -> regexPredicate.test(pageData.getContent());
            }
        }
        throw new UnsupportedOperationException();
    }

    private static <T> Predicate<PageData> prepareSupportsFunction(Class<T> entityClass) {
        Predicate<PageData> predicate = pageData -> true;
        RegexSupportsParser regexSupportsParser = entityClass.getDeclaredAnnotation(RegexSupportsParser.class);
        if (regexSupportsParser != null) {
            predicate = predicate.and(EntityParser.checkRegexSupports(regexSupportsParser));
        }
        return predicate;
    }

    private static SourceInfo prepareEntitySourceInfo(PageData pageData) {
        SourceInfo sourceInfo = new SourceInfo();
        sourceInfo.setId(pageData.getUrlKey());
        sourceInfo.setKey(pageData.getUrlKey());
        sourceInfo.setUrl(pageData.getUrl());
        return sourceInfo;
    }

    private static <T> T newInstance(Class<T> entityClass) {
        return entityClass.newInstance();
    }

    private void prepareProcessors() {
        this.beanProcessor.addProcess(new BeanFieldsParser<T>(this.entityClass));
        this.beanProcessor.addProcess(new BeanMethodsParser<T>(this.entityClass));
    }

    public boolean supports(PageData pageData) {
        return this.supportsFunction.test(pageData);
    }

    public Set<ConstraintViolation<T>> validate(T entity) {
        return this.validator.validate(entity, new Class[0]);
    }

    public T parse(PageData pageData) {
        if (pageData.getContent() != null && (pageData.getContent().contains("301 Moved Permanently") || pageData.getContent().contains("302 Found"))) {
            return null;
        }
        HtmlDocumentParser documentParser = new HtmlDocumentParser(pageData);
        return this.parse(pageData, documentParser);
    }

    public T parse(PageData pageData, HtmlParserContext context) {
        T entity = EntityParser.newInstance(this.entityClass);
        if (entity instanceof ImportedEntity) {
            ((ImportedEntity)entity).setSourceInfo(EntityParser.prepareEntitySourceInfo(pageData));
        }
        this.beanProcessor.process(pageData, context, entity);
        Set<ConstraintViolation<T>> validationResult = this.validate(entity);
        if (validationResult.size() > 0) {
            System.err.println(validationResult);
            return null;
        }
        return entity;
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }
}

