/*
 * Decompiled with CFR 0.152.
 */
package net.tislib.websiteparser.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.tislib.websiteparser.engine.EntityParser;
import net.tislib.websiteparser.engine.PageData;

public class ParserRegistry {
    private List<EntityParser> entityParsers = new ArrayList<EntityParser>();

    public <T> EntityParser<T> register(Class<T> entityClass) {
        Optional<EntityParser> entityParserOptional = this.entityParsers.stream().filter(item -> item.getEntityClass() == entityClass).findAny();
        if (entityParserOptional.isPresent()) {
            return entityParserOptional.get();
        }
        EntityParser<T> entityParser = new EntityParser<T>(this, entityClass);
        this.entityParsers.add(entityParser);
        return entityParser;
    }

    public <T> T parse(PageData pageData, Class<T> entityClass) {
        EntityParser<T> entityParser = this.register(entityClass);
        return entityParser.parse(pageData);
    }

    public Object parse(PageData pageData) {
        EntityParser entityParser = this.locateEntityParser(pageData);
        if (entityParser == null) {
            return null;
        }
        return entityParser.parse(pageData);
    }

    public EntityParser locateEntityParser(PageData pageData) {
        for (EntityParser entityParser : this.entityParsers) {
            if (!entityParser.supports(pageData)) continue;
            return entityParser;
        }
        return null;
    }
}

