/*
 * Decompiled with CFR 0.152.
 */
package net.tislib.websiteparser.engine.context;

import java.util.List;
import java.util.stream.Collectors;
import net.tislib.websiteparser.annotations.HtmlParserContext;
import net.tislib.websiteparser.engine.PageData;
import net.tislib.websiteparser.engine.context.HtmlElementParser;
import net.tislib.websiteparser.engine.context.HtmlElementsParser;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class HtmlDocumentParser
implements HtmlParserContext {
    private final PageData pageData;
    private final Document document;

    public HtmlDocumentParser(PageData pageData) {
        this.pageData = pageData;
        this.document = pageData.getContent() != null ? Jsoup.parse((String)pageData.getContent()) : Jsoup.connect((String)pageData.getUrl()).get();
    }

    public String getUrl() {
        return this.pageData.getUrl();
    }

    public String getElementText(String pattern) {
        return this.document.select(pattern).text();
    }

    public HtmlParserContext select(String selector) {
        return new HtmlElementsParser(this.document.select(selector));
    }

    public List<HtmlParserContext> selectMulti(String selector) {
        return this.document.select(selector).stream().map(HtmlElementParser::new).collect(Collectors.toList());
    }

    public String getElementAttribute(String selector, String attr) {
        return this.document.select(selector).attr(attr);
    }

    public boolean hasClass(String theClass) {
        return this.document.hasClass(theClass);
    }

    public String getElementHtml(String selector) {
        return this.document.select(selector).html();
    }
}

