/*
 * Decompiled with CFR 0.152.
 */
package net.tislib.websiteparser.engine.context;

import java.util.List;
import java.util.stream.Collectors;
import net.tislib.websiteparser.annotations.HtmlParserContext;
import net.tislib.websiteparser.engine.context.HtmlElementsParser;
import org.jsoup.nodes.Element;

public class HtmlElementParser
implements HtmlParserContext {
    private final Element element;

    public String getUrl() {
        throw new UnsupportedOperationException("sub context does not have url");
    }

    public String getElementText(String pattern) {
        if (pattern == null || pattern.equals("")) {
            return this.element.text();
        }
        return this.element.select(pattern).text();
    }

    public HtmlParserContext select(String selector) {
        return new HtmlElementsParser(this.element.select(selector));
    }

    public List<HtmlParserContext> selectMulti(String selector) {
        return this.element.select(selector).stream().map(HtmlElementParser::new).collect(Collectors.toList());
    }

    public String getElementAttribute(String selector, String attr) {
        if (selector.equals("")) {
            return this.element.attr(attr);
        }
        return this.element.select(selector).attr(attr);
    }

    public boolean hasClass(String theClass) {
        return this.element.hasClass(theClass);
    }

    public String getElementHtml(String selector) {
        return this.element.select(selector).html();
    }

    public Element getElement() {
        return this.element;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HtmlElementParser)) {
            return false;
        }
        HtmlElementParser other = (HtmlElementParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Element this$element = this.getElement();
        Element other$element = other.getElement();
        return !(this$element == null ? other$element != null : !this$element.equals(other$element));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HtmlElementParser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Element $element = this.getElement();
        result = result * 59 + ($element == null ? 43 : $element.hashCode());
        return result;
    }

    public String toString() {
        return "HtmlElementParser(element=" + this.getElement() + ")";
    }

    public HtmlElementParser(Element element) {
        this.element = element;
    }
}

