/*
 * Decompiled with CFR 0.152.
 */
package net.tislib.websiteparser.engine.context;

import java.util.List;
import java.util.stream.Collectors;
import net.tislib.websiteparser.annotations.HtmlParserContext;
import net.tislib.websiteparser.engine.context.HtmlElementParser;
import org.jsoup.select.Elements;

public class HtmlElementsParser
implements HtmlParserContext {
    private final Elements elements;

    public String getUrl() {
        throw new UnsupportedOperationException("sub context does not have url");
    }

    public String getElementText(String pattern) {
        return this.elements.select(pattern).text();
    }

    public HtmlParserContext select(String selector) {
        return new HtmlElementsParser(this.elements.select(selector));
    }

    public List<HtmlParserContext> selectMulti(String selector) {
        return this.elements.select(selector).stream().map(HtmlElementParser::new).collect(Collectors.toList());
    }

    public String getElementAttribute(String selector, String attr) {
        return this.elements.select(selector).attr(attr);
    }

    public boolean hasClass(String theClass) {
        return this.elements.hasClass(theClass);
    }

    public String getElementHtml(String selector) {
        return this.elements.select(selector).html();
    }

    public Elements getElements() {
        return this.elements;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HtmlElementsParser)) {
            return false;
        }
        HtmlElementsParser other = (HtmlElementsParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Elements this$elements = this.getElements();
        Elements other$elements = other.getElements();
        return !(this$elements == null ? other$elements != null : !this$elements.equals(other$elements));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HtmlElementsParser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Elements $elements = this.getElements();
        result = result * 59 + ($elements == null ? 43 : $elements.hashCode());
        return result;
    }

    public String toString() {
        return "HtmlElementsParser(elements=" + this.getElements() + ")";
    }

    public HtmlElementsParser(Elements elements) {
        this.elements = elements;
    }
}

