/*
 * Decompiled with CFR 0.152.
 */
package net.tislib.websiteparser.engine.parsers;

import java.lang.reflect.Field;
import net.tislib.websiteparser.annotations.EntityPart;
import net.tislib.websiteparser.annotations.HtmlParserContext;
import net.tislib.websiteparser.annotations.ParseDateTime;
import net.tislib.websiteparser.annotations.RegexTransform;
import net.tislib.websiteparser.annotations.SelectAttribute;
import net.tislib.websiteparser.annotations.SelectHtml;
import net.tislib.websiteparser.annotations.SelectText;
import net.tislib.websiteparser.annotations.SplitText;
import net.tislib.websiteparser.annotations.UrlExtract;
import net.tislib.websiteparser.annotations.generic.SourceInfo;
import net.tislib.websiteparser.engine.BeanParser;
import net.tislib.websiteparser.engine.PageData;
import net.tislib.websiteparser.engine.value.ValueProcessor;
import net.tislib.websiteparser.engine.value.ValueReader;
import net.tislib.websiteparser.engine.value.processor.DateTimeValueProcessor;
import net.tislib.websiteparser.engine.value.processor.RegexTransformValueProcessor;
import net.tislib.websiteparser.engine.value.processor.SimpleValueProcessor;
import net.tislib.websiteparser.engine.value.processor.SplitTextValueProcessor;
import net.tislib.websiteparser.engine.value.reader.ElementAttributeReader;
import net.tislib.websiteparser.engine.value.reader.ElementHtmlValueReader;
import net.tislib.websiteparser.engine.value.reader.ElementTextValueReader;
import net.tislib.websiteparser.engine.value.reader.EntityPartValueReader;
import net.tislib.websiteparser.engine.value.reader.UrlExtractValueReader;

public class BeanFieldParser<T>
implements BeanParser {
    private final Field field;
    private final ValueReader valueReader;
    private final ValueProcessor valueProcessor;

    public BeanFieldParser(Field field) {
        this.field = field;
        this.valueReader = this.prepareValueReader(field);
        this.valueProcessor = this.prepareValueProcessor(field);
    }

    private ValueProcessor prepareValueProcessor(Field field) {
        Class<?> type = field.getType();
        if (type.equals(SourceInfo.class)) {
            return ValueProcessor.noValue();
        }
        ParseDateTime parseDateTime = field.getDeclaredAnnotation(ParseDateTime.class);
        SplitText splitText = field.getDeclaredAnnotation(SplitText.class);
        RegexTransform regexTransform = field.getDeclaredAnnotation(RegexTransform.class);
        if (splitText != null) {
            return new SplitTextValueProcessor(type, splitText.pattern(), splitText.subType());
        }
        if (regexTransform != null) {
            return new RegexTransformValueProcessor(regexTransform.pattern(), regexTransform.group(), type);
        }
        if (parseDateTime != null) {
            return new DateTimeValueProcessor(parseDateTime.value());
        }
        return new SimpleValueProcessor(type);
    }

    private ValueReader prepareValueReader(Field field) {
        SelectText selectText = field.getDeclaredAnnotation(SelectText.class);
        SelectHtml selectHtml = field.getDeclaredAnnotation(SelectHtml.class);
        SelectAttribute selectAttribute = field.getDeclaredAnnotation(SelectAttribute.class);
        UrlExtract urlExtract = field.getDeclaredAnnotation(UrlExtract.class);
        EntityPart entityPart = field.getDeclaredAnnotation(EntityPart.class);
        if (selectText != null) {
            return new ElementTextValueReader(selectText.value(), selectText.multi());
        }
        if (selectHtml != null) {
            return new ElementHtmlValueReader(selectHtml.value(), selectHtml.transform());
        }
        if (selectAttribute != null) {
            return new ElementAttributeReader(selectAttribute.selector(), selectAttribute.attr());
        }
        if (urlExtract != null) {
            return new UrlExtractValueReader(urlExtract.pattern(), urlExtract.group());
        }
        if (entityPart != null) {
            return new EntityPartValueReader(field, entityPart.selectContext());
        }
        return ValueReader.empty();
    }

    @Override
    public void parse(PageData pageData, HtmlParserContext context, Object object) {
        Object value = this.valueReader.read(context);
        Object processedValue = value == null || value.equals("") || value == ValueProcessor.NO_VALUE ? ValueProcessor.NO_VALUE : this.valueProcessor.process(value);
        boolean accessibleFlag = this.field.isAccessible();
        this.field.setAccessible(true);
        if (processedValue != ValueProcessor.NO_VALUE) {
            this.field.set(object, processedValue);
        } else if (this.field.get(object) == null) {
            this.field.set(object, null);
        }
        this.field.setAccessible(accessibleFlag);
    }
}

