/*
 * Decompiled with CFR 0.152.
 */
package net.tislib.websiteparser.engine.parsers;

import com.github.slugify.Slugify;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.tislib.websiteparser.annotations.HtmlParserContext;
import net.tislib.websiteparser.annotations.ParsingHelper;
import net.tislib.websiteparser.engine.EntityParser;
import net.tislib.websiteparser.engine.NullPageData;

public class ParsingHelperImpl
implements ParsingHelper {
    private static final Slugify SLUGIFY = new Slugify().withUnderscoreSeparator(true);
    private final HtmlParserContext rootContext;
    private final Map<Class<?>, EntityParser<?>> subParserCache;

    public <T> Collection<T> parseCollection(String selector, Class<T> entityClass) {
        return this.parseCollection(this.rootContext, selector, entityClass);
    }

    public <T> Collection<T> parseCollection(HtmlParserContext htmlParserContext, String selector, Class<T> entityClass) {
        return htmlParserContext.selectMulti(selector).stream().map(item -> this.parse((HtmlParserContext)item, entityClass)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public <T> T parse(HtmlParserContext htmlParserContext, Class<T> entityClass) {
        EntityParser parser = this.subParserCache.computeIfAbsent(entityClass, u -> new EntityParser(entityClass));
        return parser.parse(NullPageData.INSTANCE, htmlParserContext);
    }

    public HtmlParserContext getHtmlParserContext() {
        return this.rootContext;
    }

    public String slugify(String text) {
        return SLUGIFY.slugify(text);
    }

    public ParsingHelperImpl(HtmlParserContext rootContext, Map<Class<?>, EntityParser<?>> subParserCache) {
        this.rootContext = rootContext;
        this.subParserCache = subParserCache;
    }
}

