/*
 * Decompiled with CFR 0.152.
 */
package net.tislib.websiteparser.engine.value.processor;

import com.sun.el.lang.ELArithmetic;
import com.sun.el.util.MessageFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.tislib.websiteparser.engine.value.ValueProcessor;

public class SimpleValueProcessor
implements ValueProcessor {
    private final Class<?> type;

    @Override
    public Object process(Object value) {
        if (this.type.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (ELArithmetic.isNumberType(this.type) && value instanceof String) {
            return this.parseNumber((String)value, this.type);
        }
        throw new RuntimeException("Unsupported type");
    }

    private Object parseNumber(String value, Class<?> type) {
        BigDecimal subPart = new BigDecimal(value.substring(0, value.length() - 1));
        BigDecimal bigDecimal = value.endsWith("K") || value.endsWith("k") ? subPart.multiply(BigDecimal.valueOf(1000L)) : (value.endsWith("M") || value.endsWith("m") ? subPart.multiply(BigDecimal.valueOf(1000000L)) : new BigDecimal(value));
        if (Long.TYPE == type || Long.class.equals(type)) {
            return bigDecimal.longValue();
        }
        if (Integer.TYPE == type || Integer.class.equals(type)) {
            return bigDecimal.intValue();
        }
        if (Double.TYPE == type || Double.class.equals(type)) {
            return bigDecimal.doubleValue();
        }
        if (BigInteger.class.equals(type)) {
            return bigDecimal.toBigInteger();
        }
        if (BigDecimal.class.equals(type)) {
            return bigDecimal;
        }
        if (Byte.TYPE == type || Byte.class.equals(type)) {
            return bigDecimal.byteValue();
        }
        if (Short.TYPE == type || Short.class.equals(type)) {
            return bigDecimal.shortValue();
        }
        if (Float.TYPE == type || Float.class.equals(type)) {
            return Float.valueOf(bigDecimal.floatValue());
        }
        throw new IllegalArgumentException(MessageFactory.get((String)"error.convert", (Object)value, String.class, type));
    }

    public SimpleValueProcessor(Class<?> type) {
        this.type = type;
    }
}

