/*
 * Decompiled with CFR 0.152.
 */
package net.tislib.websiteparser.engine.value.reader;

import com.github.slugify.Slugify;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.tislib.websiteparser.annotations.EntityPart;
import net.tislib.websiteparser.annotations.HtmlParserContext;
import net.tislib.websiteparser.annotations.MapSelector;
import net.tislib.websiteparser.engine.BeanProcessor;
import net.tislib.websiteparser.engine.NullPageData;
import net.tislib.websiteparser.engine.parsers.BeanFieldsParser;
import net.tislib.websiteparser.engine.parsers.BeanMethodsParser;
import net.tislib.websiteparser.engine.value.ValueReader;

public class EntityPartValueReader
implements ValueReader {
    private final Class<?> entityPartClass;
    private String mapKeySelector;
    private boolean isMap;
    private String mapValueSelector;
    private Class<?> mapValueTarget;
    private final String selector;
    private final Class<?> targetClass;
    private Slugify slugify = new Slugify().withUnderscoreSeparator(true);
    private BeanProcessor beanProcessor = new BeanProcessor();

    public EntityPartValueReader(Field field, String selector) {
        this.selector = selector;
        this.entityPartClass = field.getType();
        EntityPart entityPart = field.getDeclaredAnnotation(EntityPart.class);
        MapSelector mapSelector = field.getDeclaredAnnotation(MapSelector.class);
        this.targetClass = entityPart.target() == Object.class ? this.entityPartClass : entityPart.target();
        this.isMap = false;
        this.mapKeySelector = null;
        this.mapValueSelector = null;
        this.mapValueTarget = null;
        if (this.entityPartClass.isAssignableFrom(Map.class)) {
            this.isMap = true;
            if (mapSelector != null) {
                this.mapKeySelector = mapSelector.keySelector().value();
                this.mapValueSelector = mapSelector.valueSelector().selector();
                this.mapValueTarget = mapSelector.valueSelector().target();
            }
        }
        this.beanProcessor.addProcess(new BeanFieldsParser(this.targetClass));
        this.beanProcessor.addProcess(new BeanMethodsParser(this.targetClass));
    }

    @Override
    public Object read(HtmlParserContext context) {
        if (this.selector.equals("")) {
            return this.readInner(context, this.targetClass);
        }
        List newContexts = context.selectMulti(this.selector);
        if (newContexts.size() == 0) {
            return null;
        }
        if (this.isMap) {
            HashMap result = new HashMap();
            ArrayList keys = new ArrayList();
            ArrayList values = new ArrayList();
            newContexts.forEach(item -> {
                if (this.mapKeySelector != null) {
                    String key = this.slugify.slugify(item.getElementText(this.mapKeySelector));
                    List value = item.selectMulti(this.mapValueSelector).stream().map(context1 -> this.readInner((HtmlParserContext)context1, this.mapValueTarget)).collect(Collectors.toList());
                    if (!key.equals("")) {
                        keys.add(key);
                    }
                    if (value.size() > 0) {
                        values.add(value);
                    }
                } else {
                    Map.Entry entry = (Map.Entry)this.readInner((HtmlParserContext)item, this.targetClass);
                    result.put((String)entry.getKey(), entry.getValue());
                }
            });
            for (int i = 0; i < Math.min(keys.size(), values.size()); ++i) {
                result.put(keys.get(i), values.get(i));
            }
            return result;
        }
        if (this.entityPartClass.isAssignableFrom(List.class)) {
            return newContexts.stream().map(item -> this.readInner((HtmlParserContext)item, this.targetClass)).collect(Collectors.toList());
        }
        return this.readInner((HtmlParserContext)newContexts.get(0), this.targetClass);
    }

    public Object readInner(HtmlParserContext context, Class<?> entityPartClass) {
        Object object = entityPartClass.newInstance();
        this.beanProcessor.process(NullPageData.INSTANCE, context, object);
        return object;
    }
}

