/*
 * Decompiled with CFR 0.152.
 */
package com.despegar.maven.plugin.eclipse.maven;

import com.despegar.tools.hash.HashHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.sonatype.plexus.build.incremental.BuildContext;

public class MavenM2ECodeStyleMojo
extends AbstractMojo {
    private static final String ECLIPSE_SETTINGS_FOLDER = ".settings";
    private static final String CORE_PREFS_FILE = "org.eclipse.core.resources.prefs";
    private static final String JDT_CORE_PREFS_FILE = "org.eclipse.jdt.core.prefs";
    private static final String JDT_UI_PREFS_FILE = "org.eclipse.jdt.ui.prefs";
    private static final String WST_JSDT_CORE_PREFS_FILE = "org.eclipse.wst.jsdt.core.prefs";
    private static final String WST_JSDT_UI_PREFS_FILE = "org.eclipse.wst.jsdt.ui.prefs";
    private BuildContext buildContext;
    private String codeStyleBaseUrl;
    private File baseDir;
    private HttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager());

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isRunningFromEclipse()) {
            File pomFile = new File(this.baseDir, "pom.xml");
            if (this.buildContext.hasDelta(pomFile) || !this.buildContext.isIncremental()) {
                this.getLog().info((CharSequence)("Using code-style base-url [" + this.codeStyleBaseUrl + "]..."));
                File sttDir = new File(this.baseDir, ECLIPSE_SETTINGS_FOLDER);
                if (sttDir.exists()) {
                    sttDir.mkdir();
                }
                this.configureJSDTUIPrefs(sttDir, this.codeStyleBaseUrl);
                this.configureJSDTCorePrefs(sttDir, this.codeStyleBaseUrl);
                this.configureJDTUIPrefs(sttDir, this.codeStyleBaseUrl);
                this.configureJDTCorePrefs(sttDir, this.codeStyleBaseUrl);
                this.configureCorePrefs(sttDir, this.codeStyleBaseUrl);
                this.getLog().info((CharSequence)"Refreshing newly created settings...");
                this.buildContext.refresh(sttDir);
            } else {
                this.getLog().info((CharSequence)"pom.xml didn't change or incremental build detected, nothing to do.");
            }
        } else {
            this.getLog().info((CharSequence)"Eclipse not detected, exiting!");
        }
    }

    private boolean isRunningFromEclipse() {
        int hitCount = 0;
        for (Map.Entry<Object, Object> p : System.getProperties().entrySet()) {
            String key = p.getKey().toString().trim().toLowerCase();
            if (!key.startsWith("eclipse.vmargs") && !key.startsWith("eclipse.vm") && !key.startsWith("eclipse.startTime") && !key.startsWith("eclipse.commands") && !key.startsWith("eclipse.launcher")) continue;
            ++hitCount;
        }
        return hitCount >= 3;
    }

    private void configureJSDTUIPrefs(File dir, String baseUrl) {
        this.downloadAndWriteFile(dir, baseUrl, WST_JSDT_UI_PREFS_FILE);
    }

    private void configureJSDTCorePrefs(File dir, String baseUrl) {
        this.downloadAndWriteFile(dir, baseUrl, WST_JSDT_CORE_PREFS_FILE);
    }

    private void configureJDTUIPrefs(File dir, String baseUrl) {
        this.downloadAndWriteFile(dir, baseUrl, JDT_UI_PREFS_FILE);
    }

    private void configureJDTCorePrefs(File dir, String baseUrl) {
        this.downloadAndWriteFile(dir, baseUrl, JDT_CORE_PREFS_FILE);
    }

    private void configureCorePrefs(File dir, String baseUrl) {
        this.downloadAndWriteFile(dir, baseUrl, CORE_PREFS_FILE);
    }

    private void downloadAndWriteFile(File dir, String baseUrl, String fileName) {
        this.getLog().info((CharSequence)("Checking new version of [" + fileName + "]..."));
        String content = this.getUrlContentAsString(baseUrl + "/" + fileName);
        if (content != null) {
            File target = new File(dir, fileName);
            if (target.exists()) {
                String md5Old = HashHelper.md5(this.cleanUpString(this.readTextFile(target)));
                this.getLog().info((CharSequence)("Fingerprint for [" + fileName + "] = {" + md5Old + "}"));
                String md5New = HashHelper.md5(this.cleanUpString(content));
                this.getLog().info((CharSequence)("Fingerprint for [" + fileName + "] = {" + md5New + "}"));
                if (!md5New.equals(md5Old)) {
                    this.writeTextFile(target, content);
                    this.getLog().info((CharSequence)("File [" + fileName + "] updated."));
                } else {
                    this.getLog().info((CharSequence)("File [" + fileName + "] didn't change!"));
                }
            } else {
                this.writeTextFile(target, content);
                this.getLog().info((CharSequence)("New file [" + fileName + "] created."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readTextFile(File file) {
        StringBuilder sb = new StringBuilder();
        if (file.exists()) {
            FileReader inFile = null;
            try {
                inFile = new FileReader(file);
                BufferedReader in = new BufferedReader(inFile);
                String text = null;
                while ((text = in.readLine()) != null) {
                    sb.append(text).append(System.getProperty("line.separator"));
                }
            }
            catch (IOException e) {
                try {
                    this.getLog().warn((CharSequence)("Exception reading file [" + file.getName() + "]"), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inFile);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)inFile);
            }
            IOUtils.closeQuietly((Reader)inFile);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTextFile(File file, String content) {
        Properties p = new Properties();
        FileWriter outFile = null;
        try {
            if (file.exists()) {
                FileReader reader = new FileReader(file);
                p.load(reader);
                reader.close();
            }
            StringReader contentReader = new StringReader(content);
            p.load(contentReader);
            contentReader.close();
            outFile = new FileWriter(file);
            p.store(outFile, "Built by maven-m2e-codestyle");
        }
        catch (IOException e) {
            try {
                this.getLog().warn((CharSequence)("Exception writing file [" + file.getName() + "]"), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outFile);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)outFile);
        }
        IOUtils.closeQuietly((Writer)outFile);
    }

    private String cleanUpString(String content) {
        BufferedReader br = new BufferedReader(new StringReader(content));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return sb.toString();
    }

    private String getUrlContentAsString(String url) {
        if (!URI.create(url).isAbsolute()) {
            try {
                InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(url);
                if (stream == null) {
                    return null;
                }
                Scanner scanner = new Scanner(stream).useDelimiter("\\A");
                String response = scanner.hasNext() ? scanner.next() : null;
                stream.close();
                return response;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        HttpResponse httpResponse = null;
        try {
            httpResponse = this.httpClient.execute((HttpUriRequest)new HttpGet(url));
        }
        catch (ClientProtocolException e1) {
            throw new RuntimeException(e1);
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        if (httpResponse.getStatusLine().getStatusCode() == 404) {
            return null;
        }
        String response = null;
        try {
            response = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (String)"UTF-8");
        }
        catch (IllegalStateException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return response;
    }
}

