/*
 * Decompiled with CFR 0.152.
 */
package com.despegar.tools.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;

public class StreamHelper {
    public static byte[] bytesOf(Serializable obj) {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.flush();
            byArray = baos.toByteArray();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("i/o error serializing object", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(oos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)oos);
        return byArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Serializable objectOf(byte[] bytes) {
        Serializable serializable;
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(bais);
            serializable = (Serializable)ois.readObject();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("i/o error deserializing object", e);
                catch (ClassNotFoundException e2) {
                    throw new RuntimeException("class not found deserializing object", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ois);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)ois);
        return serializable;
    }
}

