/*
 * Decompiled with CFR 0.152.
 */
package net.truelicense.core;

import java.util.Optional;

final class Cache<K, V> {
    private final Optional<K> optKey;
    private final Optional<V> optValue;
    private final long cachePeriodMillis;
    private final long startTimeMillis = System.currentTimeMillis();

    Cache() {
        this(Optional.empty(), Optional.empty(), 0L);
    }

    Cache(Optional<K> optional, Optional<V> optional2, long l) {
        this.optKey = optional;
        this.optValue = optional2;
        this.cachePeriodMillis = l;
        if (0L > this.cachePeriodMillis) {
            throw new IllegalArgumentException();
        }
    }

    Cache<K, V> key(Optional<K> optional) {
        return this.hasKey(optional) ? this : new Cache<K, V>(optional, this.optValue, this.cachePeriodMillis);
    }

    Optional<V> map(Optional<K> optional) {
        return this.hasKey(optional) && !this.obsolete() ? this.optValue : Optional.empty();
    }

    boolean hasKey(Optional<K> optional) {
        return optional.equals(this.optKey);
    }

    boolean obsolete() {
        return System.currentTimeMillis() - this.startTimeMillis >= this.cachePeriodMillis;
    }
}

