/*
 * Decompiled with CFR 0.152.
 */
package net.truelicense.core;

import java.nio.file.Path;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.security.auth.x500.X500Principal;
import net.truelicense.api.AuthenticationInjection;
import net.truelicense.api.ConsumerLicenseManager;
import net.truelicense.api.ConsumerLicenseManagerBuilder;
import net.truelicense.api.EncryptionInjection;
import net.truelicense.api.License;
import net.truelicense.api.LicenseApplicationContext;
import net.truelicense.api.LicenseFactory;
import net.truelicense.api.LicenseFunctionComposition;
import net.truelicense.api.LicenseInitialization;
import net.truelicense.api.LicenseInitializationProvider;
import net.truelicense.api.LicenseKeyGenerator;
import net.truelicense.api.LicenseManagementAuthorization;
import net.truelicense.api.LicenseManagementAuthorizationProvider;
import net.truelicense.api.LicenseManagementContext;
import net.truelicense.api.LicenseManagementContextBuilder;
import net.truelicense.api.LicenseManagementException;
import net.truelicense.api.LicenseManagementParameters;
import net.truelicense.api.LicenseManagementSchema;
import net.truelicense.api.LicenseManagementSubjectProvider;
import net.truelicense.api.LicenseValidation;
import net.truelicense.api.LicenseValidationException;
import net.truelicense.api.LicenseValidationProvider;
import net.truelicense.api.UncheckedConsumerLicenseManager;
import net.truelicense.api.UncheckedLicenseKeyGenerator;
import net.truelicense.api.UncheckedLicenseManagementException;
import net.truelicense.api.UncheckedVendorLicenseManager;
import net.truelicense.api.VendorLicenseManager;
import net.truelicense.api.VendorLicenseManagerBuilder;
import net.truelicense.api.auth.Authentication;
import net.truelicense.api.auth.AuthenticationParameters;
import net.truelicense.api.auth.RepositoryContext;
import net.truelicense.api.auth.RepositoryContextProvider;
import net.truelicense.api.auth.RepositoryController;
import net.truelicense.api.codec.Codec;
import net.truelicense.api.codec.CodecProvider;
import net.truelicense.api.codec.Decoder;
import net.truelicense.api.comp.CompressionProvider;
import net.truelicense.api.crypto.EncryptionParameters;
import net.truelicense.api.io.Sink;
import net.truelicense.api.io.Source;
import net.truelicense.api.io.Store;
import net.truelicense.api.io.Transformation;
import net.truelicense.api.misc.Builder;
import net.truelicense.api.misc.CachePeriodProvider;
import net.truelicense.api.misc.ClassLoaderProvider;
import net.truelicense.api.misc.Clock;
import net.truelicense.api.misc.ContextProvider;
import net.truelicense.api.passwd.Password;
import net.truelicense.api.passwd.PasswordPolicy;
import net.truelicense.api.passwd.PasswordPolicyProvider;
import net.truelicense.api.passwd.PasswordProtection;
import net.truelicense.api.passwd.PasswordProtectionProvider;
import net.truelicense.api.passwd.PasswordUsage;
import net.truelicense.core.Cache;
import net.truelicense.core.Messages;
import net.truelicense.core.TrueLicenseApplicationContext;
import net.truelicense.core.TrueLicenseManagementAuthorization;
import net.truelicense.core.auth.Notary;
import net.truelicense.core.passwd.MinimumPasswordPolicy;
import net.truelicense.core.passwd.ObfuscatedPasswordProtection;
import net.truelicense.obfuscate.ObfuscatedString;
import net.truelicense.spi.io.BIOS;
import net.truelicense.spi.io.BiosProvider;
import net.truelicense.spi.io.MemoryStore;
import net.truelicense.spi.io.StandardBIOS;

public abstract class TrueLicenseApplicationContext<Model>
implements BiosProvider,
CachePeriodProvider,
ClassLoaderProvider,
Clock,
CodecProvider,
CompressionProvider,
LicenseApplicationContext,
LicenseManagementAuthorizationProvider,
LicenseFactory,
PasswordPolicyProvider,
PasswordProtectionProvider<ObfuscatedString>,
RepositoryContextProvider<Model> {
    public Authentication authentication(AuthenticationParameters authenticationParameters) {
        return new Notary(authenticationParameters);
    }

    public final LicenseManagementAuthorization authorization() {
        return new TrueLicenseManagementAuthorization();
    }

    public BIOS bios() {
        return new StandardBIOS();
    }

    public long cachePeriodMillis() {
        return 1800000L;
    }

    public final Optional<ClassLoader> classLoader() {
        return Optional.ofNullable(Thread.currentThread().getContextClassLoader());
    }

    public final LicenseManagementContextBuilder context() {
        return new TrueLicenseManagementContextBuilder();
    }

    public abstract Transformation encryption(EncryptionParameters var1);

    public final Date now() {
        return new Date();
    }

    public abstract String pbeAlgorithm();

    public PasswordPolicy policy() {
        return new MinimumPasswordPolicy();
    }

    public final PasswordProtection protection(long[] lArray) {
        return this.protection(new ObfuscatedString(lArray));
    }

    public final PasswordProtection protection(ObfuscatedString obfuscatedString) {
        return new ObfuscatedPasswordProtection(obfuscatedString);
    }

    public abstract String storeType();

    private static String requireNonEmpty(String string) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return string;
    }

    private static boolean exists(Store store) throws LicenseManagementException {
        return TrueLicenseApplicationContext.check(() -> ((Store)store).exists());
    }

    private static <V> V check(Callable<V> callable) throws LicenseManagementException {
        try {
            return callable.call();
        }
        catch (RuntimeException | LicenseManagementException throwable) {
            throw throwable;
        }
        catch (Exception exception) {
            throw new LicenseManagementException((Throwable)exception);
        }
    }

    private static <V> V uncheck(Callable<V> callable) {
        try {
            return callable.call();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new UncheckedLicenseManagementException((Throwable)exception);
        }
    }

    final class TrueLicenseManagementContext
    implements Clock,
    ContextProvider<TrueLicenseApplicationContext>,
    LicenseManagementAuthorizationProvider,
    LicenseInitializationProvider,
    LicenseManagementContext,
    LicenseManagementSubjectProvider,
    LicenseValidationProvider {
        final LicenseManagementAuthorization authorization;
        final ClassLoaderProvider classLoaderProvider;
        final Clock clock;
        final Optional<LicenseInitialization> initialization;
        final LicenseFunctionComposition initializationComposition;
        final String subject;
        final Optional<LicenseValidation> validation;
        final LicenseFunctionComposition validationComposition;

        TrueLicenseManagementContext(TrueLicenseManagementContextBuilder trueLicenseManagementContextBuilder) {
            this.authorization = trueLicenseManagementContextBuilder.authorization;
            this.classLoaderProvider = trueLicenseManagementContextBuilder.classLoaderProvider;
            this.clock = trueLicenseManagementContextBuilder.clock;
            this.initialization = trueLicenseManagementContextBuilder.initialization;
            this.initializationComposition = trueLicenseManagementContextBuilder.initializationComposition;
            this.subject = TrueLicenseApplicationContext.requireNonEmpty(trueLicenseManagementContextBuilder.subject);
            this.validation = trueLicenseManagementContextBuilder.validation;
            this.validationComposition = trueLicenseManagementContextBuilder.validationComposition;
        }

        public LicenseManagementAuthorization authorization() {
            return this.authorization;
        }

        public Optional<ClassLoader> classLoader() {
            return this.classLoaderProvider.classLoader();
        }

        public Codec codec() {
            return this.context().codec();
        }

        public ConsumerLicenseManagerBuilder consumer() {
            return new ConsumerTrueLicenseManagerBuilder();
        }

        public TrueLicenseApplicationContext<Model> context() {
            return TrueLicenseApplicationContext.this;
        }

        public LicenseInitialization initialization() {
            TrueLicenseInitialization trueLicenseInitialization = new TrueLicenseInitialization();
            return this.initialization.map(licenseInitialization2 -> this.initializationComposition.compose(licenseInitialization2, trueLicenseInitialization)).orElse(trueLicenseInitialization);
        }

        public License license() {
            return this.context().license();
        }

        public MemoryStore memoryStore() {
            return new MemoryStore();
        }

        public Date now() {
            return this.clock.now();
        }

        public Store pathStore(Path path) {
            return TrueLicenseApplicationContext.this.bios().pathStore(path);
        }

        public Source resource(String string) {
            return TrueLicenseApplicationContext.this.bios().resource(string, this.classLoader());
        }

        public Source stdin() {
            return TrueLicenseApplicationContext.this.bios().stdin();
        }

        public Sink stdout() {
            return TrueLicenseApplicationContext.this.bios().stdout();
        }

        public String subject() {
            return this.subject;
        }

        public Store systemPreferencesStore(Class<?> clazz) {
            return TrueLicenseApplicationContext.this.bios().systemPreferencesStore(clazz, this.subject());
        }

        public Store userPreferencesStore(Class<?> clazz) {
            return TrueLicenseApplicationContext.this.bios().userPreferencesStore(clazz, this.subject());
        }

        public LicenseValidation validation() {
            TrueLicenseValidation trueLicenseValidation = new TrueLicenseValidation();
            return this.validation.map(licenseValidation2 -> this.validationComposition.compose(licenseValidation2, trueLicenseValidation)).orElse(trueLicenseValidation);
        }

        public VendorLicenseManagerBuilder vendor() {
            return new VendorTrueLicenseManagerBuilder();
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        final class TrueLicenseValidation
        implements LicenseValidation {
            TrueLicenseValidation() {
            }

            public void validate(License license) throws LicenseValidationException {
                if (0 >= license.getConsumerAmount()) {
                    throw new LicenseValidationException(Messages.message(TrueLicenseValidation._string#0(), license.getConsumerAmount()));
                }
                if (null == license.getConsumerType()) {
                    throw new LicenseValidationException(Messages.message(TrueLicenseValidation._string#1(), new Object[0]));
                }
                if (null == license.getHolder()) {
                    throw new LicenseValidationException(Messages.message(TrueLicenseValidation._string#2(), new Object[0]));
                }
                if (null == license.getIssued()) {
                    throw new LicenseValidationException(Messages.message(TrueLicenseValidation._string#3(), new Object[0]));
                }
                if (null == license.getIssuer()) {
                    throw new LicenseValidationException(Messages.message(TrueLicenseValidation._string#4(), new Object[0]));
                }
                Date date = TrueLicenseManagementContext.this.now();
                Date date2 = license.getNotAfter();
                if (null != date2 && date.after(date2)) {
                    throw new LicenseValidationException(Messages.message(TrueLicenseValidation._string#5(), date2));
                }
                Date date3 = license.getNotBefore();
                if (null != date3 && date.before(date3)) {
                    throw new LicenseValidationException(Messages.message(TrueLicenseValidation._string#6(), date3));
                }
                if (!TrueLicenseManagementContext.this.subject().equals(license.getSubject())) {
                    throw new LicenseValidationException(Messages.message(TrueLicenseValidation._string#7(), license.getSubject(), TrueLicenseManagementContext.this.subject()));
                }
            }

            private static /* synthetic */ String _string#0() {
                return new ObfuscatedString(new long[]{-5719886797473195108L, 7571370908520907196L, -7174477237876313337L, -1106673954854728916L, 678217689575294780L}).toString();
            }

            private static /* synthetic */ String _string#1() {
                return new ObfuscatedString(new long[]{4371126976911577404L, 6160573364952103394L, 3731366743817317409L, 4690874041237369744L}).toString();
            }

            private static /* synthetic */ String _string#2() {
                return new ObfuscatedString(new long[]{23297365833030294L, 962555731281049793L, 8438389079550368114L}).toString();
            }

            private static /* synthetic */ String _string#3() {
                return new ObfuscatedString(new long[]{-1645245697170072251L, -6063661796542648695L, -6858144790292087925L}).toString();
            }

            private static /* synthetic */ String _string#4() {
                return new ObfuscatedString(new long[]{8814883906051285479L, 7164586693760372689L, -406245477428669199L}).toString();
            }

            private static /* synthetic */ String _string#5() {
                return new ObfuscatedString(new long[]{-7134625166157621390L, -4557882413837961263L, -4639843404376489561L, 5525138728165501966L}).toString();
            }

            private static /* synthetic */ String _string#6() {
                return new ObfuscatedString(new long[]{-3432501151361697214L, -3621469106545132202L, -7659714332152877360L, 3577084176227059949L}).toString();
            }

            private static /* synthetic */ String _string#7() {
                return new ObfuscatedString(new long[]{6291110379319535937L, -927311845328079974L, -6187086096804372175L}).toString();
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        final class TrueLicenseInitialization
        implements LicenseInitialization {
            TrueLicenseInitialization() {
            }

            public void initialize(License license) {
                if (null == license.getConsumerType()) {
                    license.setConsumerType(TrueLicenseInitialization.DEFAULT_CONSUMER_TYPE());
                }
                if (null == license.getHolder()) {
                    license.setHolder(new X500Principal(TrueLicenseInitialization.CN_PREFIX() + Messages.message(TrueLicenseInitialization._string#2(), new Object[0])));
                }
                if (null == license.getIssued()) {
                    license.setIssued(TrueLicenseManagementContext.this.now());
                }
                if (null == license.getIssuer()) {
                    license.setIssuer(new X500Principal(TrueLicenseInitialization.CN_PREFIX() + TrueLicenseManagementContext.this.subject()));
                }
                if (null == license.getSubject()) {
                    license.setSubject(TrueLicenseManagementContext.this.subject());
                }
            }

            static final /* synthetic */ String DEFAULT_CONSUMER_TYPE() {
                return new ObfuscatedString(new long[]{-2686763198558971367L, 2418953589336169622L}).toString();
            }

            static final /* synthetic */ String CN_PREFIX() {
                return new ObfuscatedString(new long[]{5071585451287961958L, 5695268695369970954L}).toString();
            }

            private static /* synthetic */ String _string#2() {
                return new ObfuscatedString(new long[]{4597837748674387013L, -8384346155745876492L}).toString();
            }
        }

        static final class TrueLicenseManagementParameters
        implements ContextProvider<TrueLicenseManagementContext>,
        LicenseInitializationProvider,
        LicenseManagementParameters {
            final Authentication authentication;
            final Optional<Transformation> encryption;
            final int ftpDays;
            final Optional<ConsumerLicenseManager> parent;
            final Optional<Store> store;
            final /* synthetic */ TrueLicenseManagementContext this$1;

            TrueLicenseManagementParameters(net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext.TrueLicenseManagerBuilder<?> trueLicenseManagerBuilder) {
                this.this$1 = var1_1;
                this.authentication = trueLicenseManagerBuilder.authentication.get();
                this.encryption = trueLicenseManagerBuilder.encryption;
                this.ftpDays = trueLicenseManagerBuilder.ftpDays;
                this.parent = trueLicenseManagerBuilder.parent;
                this.store = trueLicenseManagerBuilder.store;
            }

            public Authentication authentication() {
                return this.authentication;
            }

            public TrueLicenseManagementContext context() {
                return this.this$1;
            }

            public Transformation encryption() {
                return this.encryption.orElseGet(() -> this.parent().parameters().encryption());
            }

            public LicenseInitialization initialization() {
                LicenseInitialization licenseInitialization = this.context().initialization();
                if (0 != this.ftpDays) {
                    return license -> {
                        licenseInitialization.initialize(license);
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(license.getIssued());
                        license.setNotBefore(calendar.getTime());
                        calendar.add(5, this.ftpDays);
                        license.setNotAfter(calendar.getTime());
                    };
                }
                return licenseInitialization;
            }

            ConsumerLicenseManager parent() {
                return this.parent.get();
            }

            Store store() {
                return this.store.get();
            }

            Transformation compressionThenEncryption() {
                return this.this$1.TrueLicenseApplicationContext.this.compression().andThen(this.encryption());
            }

            class TrueLicenseManager
            implements ConsumerLicenseManager,
            VendorLicenseManager {
                TrueLicenseManager() {
                }

                public LicenseKeyGenerator generateKeyFrom(final License license) throws LicenseManagementException {
                    return (LicenseKeyGenerator)TrueLicenseApplicationContext.check(() -> {
                        TrueLicenseManagementParameters.this.this$1.authorization().clearGenerate((LicenseManagementSchema)this);
                        class TrueLicenseKeyGenerator
                        implements LicenseKeyGenerator {
                            final RepositoryContext<Model> context;
                            final Model model;
                            Decoder decoder;

                            TrueLicenseKeyGenerator() {
                                this.context = TrueLicenseManagementParameters.this.this$1.TrueLicenseApplicationContext.this.repositoryContext();
                                this.model = this.context.model();
                            }

                            public License license() throws LicenseManagementException {
                                return (License)TrueLicenseApplicationContext.check(() -> (License)this.decoder().decode(License.class));
                            }

                            public LicenseKeyGenerator saveTo(Sink sink) throws LicenseManagementException {
                                TrueLicenseApplicationContext.check(() -> {
                                    TrueLicenseManagementParameters.this.this$1.codec().encoder(TrueLicenseManagementParameters.this.compressionThenEncryption().apply(sink)).encode(this.model());
                                    return null;
                                });
                                return this;
                            }

                            Decoder decoder() throws Exception {
                                this.init();
                                return this.decoder;
                            }

                            Model model() throws Exception {
                                this.init();
                                return this.model;
                            }

                            synchronized void init() throws Exception {
                                if (null == this.decoder) {
                                    this.decoder = TrueLicenseManagementParameters.this.authentication().sign(this.context.controller(this.model, TrueLicenseManagementParameters.this.this$1.codec()), (Object)this.validatedBean());
                                }
                            }

                            License validatedBean() throws Exception {
                                License license2 = this.initializedBean();
                                TrueLicenseManagementParameters.this.this$1.validation().validate(license2);
                                return license2;
                            }

                            License initializedBean() throws Exception {
                                License license2 = this.duplicatedBean();
                                TrueLicenseManagementParameters.this.initialization().initialize(license2);
                                return license2;
                            }

                            License duplicatedBean() throws Exception {
                                return (License)TrueLicenseManagementParameters.this.this$1.memoryStore().clone((Object)license, TrueLicenseManagementParameters.this.this$1.codec());
                            }
                        }
                        return new TrueLicenseKeyGenerator();
                    });
                }

                public void install(Source source) throws LicenseManagementException {
                    TrueLicenseApplicationContext.check(() -> {
                        TrueLicenseManagementParameters.this.this$1.authorization().clearInstall((LicenseManagementSchema)this);
                        this.decodeLicense(source);
                        TrueLicenseManagementParameters.this.this$1.TrueLicenseApplicationContext.this.bios().copy(source, (Sink)TrueLicenseManagementParameters.this.store());
                        return null;
                    });
                }

                public License load() throws LicenseManagementException {
                    return (License)TrueLicenseApplicationContext.check(() -> {
                        TrueLicenseManagementParameters.this.this$1.authorization().clearLoad((LicenseManagementSchema)this);
                        return this.decodeLicense((Source)TrueLicenseManagementParameters.this.store());
                    });
                }

                public void verify() throws LicenseManagementException {
                    TrueLicenseApplicationContext.check(() -> {
                        TrueLicenseManagementParameters.this.this$1.authorization().clearVerify((LicenseManagementSchema)this);
                        this.validate((Source)TrueLicenseManagementParameters.this.store());
                        return null;
                    });
                }

                public void uninstall() throws LicenseManagementException {
                    TrueLicenseApplicationContext.check(() -> {
                        TrueLicenseManagementParameters.this.this$1.authorization().clearUninstall((LicenseManagementSchema)this);
                        Store store = TrueLicenseManagementParameters.this.store();
                        this.authenticate((Source)store);
                        store.delete();
                        return null;
                    });
                }

                void validate(Source source) throws Exception {
                    TrueLicenseManagementParameters.this.this$1.validation().validate(this.decodeLicense(source));
                }

                License decodeLicense(Source source) throws Exception {
                    return (License)this.authenticate(source).decode(License.class);
                }

                Decoder authenticate(Source source) throws Exception {
                    return TrueLicenseManagementParameters.this.authentication().verify(this.repositoryController(source));
                }

                RepositoryController repositoryController(Source source) throws Exception {
                    return TrueLicenseManagementParameters.this.this$1.TrueLicenseApplicationContext.this.repositoryContext().controller(this.repositoryModel(source), TrueLicenseManagementParameters.this.this$1.codec());
                }

                Model repositoryModel(Source source) throws Exception {
                    return TrueLicenseManagementParameters.this.this$1.codec().decoder(this.decryptedAndDecompressedSource(source)).decode(TrueLicenseManagementParameters.this.this$1.TrueLicenseApplicationContext.this.repositoryContext().model().getClass());
                }

                Source decryptedAndDecompressedSource(Source source) {
                    return TrueLicenseManagementParameters.this.compressionThenEncryption().unapply(source);
                }

                public final LicenseManagementContext context() {
                    return TrueLicenseManagementParameters.this.this$1;
                }

                public final net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext.TrueLicenseManagementParameters parameters() {
                    return TrueLicenseManagementParameters.this;
                }

                public net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext.TrueLicenseManagementParameters.TrueLicenseManager.UncheckedTrueLicenseManager unchecked() {
                    return new UncheckedTrueLicenseManager();
                }

                private class UncheckedTrueLicenseManager
                implements UncheckedVendorLicenseManager,
                UncheckedConsumerLicenseManager {
                    private UncheckedTrueLicenseManager() {
                    }

                    public UncheckedLicenseKeyGenerator generateKeyFrom(final License license) throws UncheckedLicenseManagementException {
                        return (UncheckedLicenseKeyGenerator)TrueLicenseApplicationContext.uncheck(() -> new UncheckedLicenseKeyGenerator(){
                            final LicenseKeyGenerator generator;
                            {
                                this.generator = UncheckedTrueLicenseManager.this.checked().generateKeyFrom(license);
                            }

                            public License license() throws UncheckedLicenseManagementException {
                                return (License)TrueLicenseApplicationContext.uncheck(() -> ((LicenseKeyGenerator)this.generator).license());
                            }

                            public LicenseKeyGenerator saveTo(Sink sink) throws UncheckedLicenseManagementException {
                                return (LicenseKeyGenerator)TrueLicenseApplicationContext.uncheck(() -> this.generator.saveTo(sink));
                            }
                        });
                    }

                    public void install(Source source) throws UncheckedLicenseManagementException {
                        TrueLicenseApplicationContext.uncheck(() -> {
                            this.checked().install(source);
                            return null;
                        });
                    }

                    public License load() throws UncheckedLicenseManagementException {
                        return (License)TrueLicenseApplicationContext.uncheck(((TrueLicenseManager)this.checked())::load);
                    }

                    public void verify() throws UncheckedLicenseManagementException {
                        TrueLicenseApplicationContext.uncheck(() -> {
                            this.checked().verify();
                            return null;
                        });
                    }

                    public void uninstall() throws UncheckedLicenseManagementException {
                        TrueLicenseApplicationContext.uncheck(() -> {
                            this.checked().uninstall();
                            return null;
                        });
                    }

                    public LicenseManagementContext context() {
                        return this.checked().context();
                    }

                    public LicenseManagementParameters parameters() {
                        return this.checked().parameters();
                    }

                    public net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext.TrueLicenseManagementParameters.TrueLicenseManager checked() {
                        return TrueLicenseManager.this;
                    }
                }
            }

            /*
             * Illegal identifiers - consider using --renameillegalidents true
             * Signature claims super is net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext.TrueLicenseManagementParameters.TrueLicenseManager, not net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext$TrueLicenseManagementParameters$TrueLicenseManager - discarding signature.
             */
            class CachingTrueLicenseManager
            extends TrueLicenseManager {
                volatile Cache<Source, Decoder> cachedDecoder = new Cache();
                volatile Cache<Source, License> cachedLicense = new Cache();
                static final /* synthetic */ boolean $assertionsDisabled;

                CachingTrueLicenseManager() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void install(Source source) throws LicenseManagementException {
                    Store store;
                    Store store2 = store = TrueLicenseManagementParameters.this.store();
                    synchronized (store2) {
                        super.install(source);
                        Optional<Source> optional = Optional.ofNullable(source);
                        Optional<Store> optional2 = Optional.of(store);
                        if (!($assertionsDisabled || this.cachedDecoder.hasKey(optional) || this.cachedDecoder.hasKey(optional2) || this.cachedDecoder.obsolete())) {
                            throw new AssertionError();
                        }
                        if (!($assertionsDisabled || this.cachedLicense.hasKey(optional) || this.cachedLicense.hasKey(optional2) || this.cachedLicense.obsolete())) {
                            throw new AssertionError();
                        }
                        this.cachedDecoder = this.cachedDecoder.key(optional2);
                        this.cachedLicense = this.cachedLicense.key(optional2);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void uninstall() throws LicenseManagementException {
                    Cache cache = new Cache();
                    Cache cache2 = new Cache();
                    Store store = TrueLicenseManagementParameters.this.store();
                    synchronized (store) {
                        super.uninstall();
                        this.cachedDecoder = cache;
                        this.cachedLicense = cache2;
                    }
                }

                @Override
                void validate(Source source) throws Exception {
                    Optional<Source> optional = Optional.ofNullable(source);
                    Optional<License> optional2 = this.cachedLicense.map(optional);
                    if (!optional2.isPresent()) {
                        optional2 = Optional.of(this.decodeLicense(source));
                        this.cachedLicense = new Cache<Source, License>(optional, optional2, TrueLicenseManagementParameters.this.this$1.TrueLicenseApplicationContext.this.cachePeriodMillis());
                    }
                    TrueLicenseManagementParameters.this.this$1.validation().validate(optional2.get());
                }

                @Override
                Decoder authenticate(Source source) throws Exception {
                    Optional<Source> optional = Optional.ofNullable(source);
                    Optional<Decoder> optional2 = this.cachedDecoder.map(optional);
                    if (!optional2.isPresent()) {
                        optional2 = Optional.of(super.authenticate(source));
                        this.cachedDecoder = new Cache<Source, Decoder>(optional, optional2, TrueLicenseManagementParameters.this.this$1.TrueLicenseApplicationContext.this.cachePeriodMillis());
                    }
                    return optional2.get();
                }

                static {
                    CachingTrueLicenseManager.$assertionsDisabled = !TrueLicenseApplicationContext.class.desiredAssertionStatus();
                }
            }

            /*
             * Signature claims super is net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext.TrueLicenseManagementParameters.CachingTrueLicenseManager, not net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext$TrueLicenseManagementParameters$CachingTrueLicenseManager - discarding signature.
             */
            final class ChainedTrueLicenseManager
            extends CachingTrueLicenseManager {
                volatile Optional<Boolean> canGenerateLicenseKeys = Optional.empty();

                ChainedTrueLicenseManager() {
                }

                @Override
                public void install(Source source) throws LicenseManagementException {
                    try {
                        TrueLicenseManagementParameters.this.parent().install(source);
                    }
                    catch (LicenseManagementException licenseManagementException) {
                        if (this.canGenerateLicenseKeys()) {
                            throw licenseManagementException;
                        }
                        super.install(source);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public License load() throws LicenseManagementException {
                    try {
                        return TrueLicenseManagementParameters.this.parent().load();
                    }
                    catch (LicenseManagementException licenseManagementException) {
                        try {
                            return super.load();
                        }
                        catch (LicenseManagementException licenseManagementException2) {
                            Store store = TrueLicenseManagementParameters.this.store();
                            synchronized (store) {
                                try {
                                    return super.load();
                                }
                                catch (LicenseManagementException licenseManagementException3) {
                                    return this.generateIffNewFtp(licenseManagementException3).license();
                                }
                            }
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void verify() throws LicenseManagementException {
                    try {
                        TrueLicenseManagementParameters.this.parent().verify();
                    }
                    catch (LicenseManagementException licenseManagementException) {
                        try {
                            super.verify();
                        }
                        catch (LicenseManagementException licenseManagementException2) {
                            Store store = TrueLicenseManagementParameters.this.store();
                            synchronized (store) {
                                try {
                                    super.verify();
                                }
                                catch (LicenseManagementException licenseManagementException3) {
                                    this.generateIffNewFtp(licenseManagementException3);
                                }
                            }
                        }
                    }
                }

                @Override
                public void uninstall() throws LicenseManagementException {
                    try {
                        TrueLicenseManagementParameters.this.parent().uninstall();
                    }
                    catch (LicenseManagementException licenseManagementException) {
                        if (this.canGenerateLicenseKeys()) {
                            throw licenseManagementException;
                        }
                        super.uninstall();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                boolean canGenerateLicenseKeys() {
                    if (!this.canGenerateLicenseKeys.isPresent()) {
                        ChainedTrueLicenseManager chainedTrueLicenseManager = this;
                        synchronized (chainedTrueLicenseManager) {
                            if (!this.canGenerateLicenseKeys.isPresent()) {
                                try {
                                    super.generateKeyFrom(TrueLicenseManagementParameters.this.this$1.license()).saveTo((Sink)TrueLicenseManagementParameters.this.this$1.memoryStore());
                                    this.canGenerateLicenseKeys = Optional.of(Boolean.TRUE);
                                }
                                catch (LicenseManagementException licenseManagementException) {
                                    this.canGenerateLicenseKeys = Optional.of(Boolean.FALSE);
                                }
                            }
                        }
                    }
                    return this.canGenerateLicenseKeys.get();
                }

                LicenseKeyGenerator generateIffNewFtp(LicenseManagementException licenseManagementException) throws LicenseManagementException {
                    if (!this.canGenerateLicenseKeys()) {
                        throw licenseManagementException;
                    }
                    Store store = TrueLicenseManagementParameters.this.store();
                    if (TrueLicenseApplicationContext.exists(store)) {
                        throw licenseManagementException;
                    }
                    return super.generateKeyFrom(TrueLicenseManagementParameters.this.this$1.license()).saveTo((Sink)store);
                }
            }
        }

        static final class TrueEncryptionParameters
        implements EncryptionParameters {
            final Optional<String> algorithm;
            final PasswordProtection protection;
            final /* synthetic */ TrueLicenseManagementContext this$1;

            TrueEncryptionParameters(net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext.TrueLicenseManagerBuilder$TrueEncryptionBuilder trueEncryptionBuilder) {
                this.this$1 = var1_1;
                this.algorithm = trueEncryptionBuilder.algorithm;
                this.protection = trueEncryptionBuilder.protection.get();
            }

            public String algorithm() {
                return this.algorithm.orElseGet(this.this$1.TrueLicenseApplicationContext.this::pbeAlgorithm);
            }

            public PasswordProtection protection() {
                return new CheckedPasswordProtection(this.protection);
            }
        }

        static final class TrueAuthenticationParameters
        implements AuthenticationParameters {
            final Optional<String> algorithm;
            final String alias;
            final Optional<PasswordProtection> keyProtection;
            final Optional<Source> source;
            final PasswordProtection storeProtection;
            final Optional<String> storeType;
            final /* synthetic */ TrueLicenseManagementContext this$1;

            TrueAuthenticationParameters(net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext.TrueLicenseManagerBuilder$TrueAuthenticationBuilder trueAuthenticationBuilder) {
                this.this$1 = var1_1;
                this.algorithm = trueAuthenticationBuilder.algorithm;
                this.alias = trueAuthenticationBuilder.alias.get();
                this.keyProtection = trueAuthenticationBuilder.keyProtection;
                this.source = trueAuthenticationBuilder.source;
                this.storeProtection = trueAuthenticationBuilder.storeProtection.get();
                this.storeType = trueAuthenticationBuilder.storeType;
            }

            public String alias() {
                return this.alias;
            }

            public PasswordProtection keyProtection() {
                return this.keyProtection.map(passwordProtection -> new CheckedPasswordProtection((PasswordProtection)passwordProtection)).orElseGet(() -> new CheckedPasswordProtection(this.storeProtection));
            }

            public Optional<String> algorithm() {
                return this.algorithm;
            }

            public Optional<Source> source() {
                return this.source;
            }

            public PasswordProtection storeProtection() {
                return new CheckedPasswordProtection(this.storeProtection);
            }

            public String storeType() {
                return this.storeType.orElseGet(() -> ((TrueLicenseApplicationContext)this.this$1.context()).storeType());
            }
        }

        abstract class TrueLicenseManagerBuilder<This extends net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext.TrueLicenseManagerBuilder<This>> {
            Optional<Authentication> authentication = Optional.empty();
            Optional<Transformation> encryption = Optional.empty();
            int ftpDays;
            Optional<ConsumerLicenseManager> parent = Optional.empty();
            Optional<Store> store = Optional.empty();

            TrueLicenseManagerBuilder() {
            }

            public final This authentication(Authentication authentication) {
                this.authentication = Optional.ofNullable(authentication);
                return (This)this;
            }

            public final net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext.TrueLicenseManagerBuilder$TrueEncryptionBuilder encryption() {
                return new TrueEncryptionBuilder();
            }

            public final This encryption(Transformation transformation) {
                this.encryption = Optional.ofNullable(transformation);
                return (This)this;
            }

            public final This ftpDays(int n) {
                this.ftpDays = n;
                return (This)this;
            }

            public final net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext.TrueLicenseManagerBuilder$TrueAuthenticationBuilder authentication() {
                return new TrueAuthenticationBuilder();
            }

            public final This parent(ConsumerLicenseManager consumerLicenseManager) {
                this.parent = Optional.ofNullable(consumerLicenseManager);
                return (This)this;
            }

            public final This storeIn(Store store) {
                this.store = Optional.ofNullable(store);
                return (This)this;
            }

            public final This storeInPath(Path path) {
                return this.storeIn(TrueLicenseManagementContext.this.pathStore(path));
            }

            public final This storeInSystemPreferences(Class<?> clazz) {
                return this.storeIn(TrueLicenseManagementContext.this.systemPreferencesStore(clazz));
            }

            public final This storeInUserPreferences(Class<?> clazz) {
                return this.storeIn(TrueLicenseManagementContext.this.userPreferencesStore(clazz));
            }

            final class TrueEncryptionBuilder
            implements Builder<Transformation>,
            EncryptionInjection<This> {
                Optional<String> algorithm = Optional.empty();
                Optional<PasswordProtection> protection = Optional.empty();

                TrueEncryptionBuilder() {
                }

                public This inject() {
                    return TrueLicenseManagerBuilder.this.encryption(this.build());
                }

                public net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext.TrueLicenseManagerBuilder$TrueEncryptionBuilder algorithm(String string) {
                    this.algorithm = Optional.ofNullable(string);
                    return this;
                }

                public Transformation build() {
                    return ((TrueLicenseApplicationContext)TrueLicenseManagementContext.this.context()).encryption(new TrueEncryptionParameters(TrueLicenseManagementContext.this, this));
                }

                public net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext.TrueLicenseManagerBuilder$TrueEncryptionBuilder protection(PasswordProtection passwordProtection) {
                    this.protection = Optional.ofNullable(passwordProtection);
                    return this;
                }
            }

            final class TrueAuthenticationBuilder
            implements Builder<Authentication>,
            AuthenticationInjection<This> {
                Optional<String> algorithm = Optional.empty();
                Optional<String> alias = Optional.empty();
                Optional<PasswordProtection> keyProtection = Optional.empty();
                Optional<Source> source = Optional.empty();
                Optional<PasswordProtection> storeProtection = Optional.empty();
                Optional<String> storeType = Optional.empty();

                TrueAuthenticationBuilder() {
                }

                public This inject() {
                    return TrueLicenseManagerBuilder.this.authentication(this.build());
                }

                public net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext.TrueLicenseManagerBuilder$TrueAuthenticationBuilder algorithm(String string) {
                    this.algorithm = Optional.ofNullable(string);
                    return this;
                }

                public net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext.TrueLicenseManagerBuilder$TrueAuthenticationBuilder alias(String string) {
                    this.alias = Optional.ofNullable(string);
                    return this;
                }

                public Authentication build() {
                    return ((TrueLicenseApplicationContext)TrueLicenseManagementContext.this.context()).authentication(new TrueAuthenticationParameters(TrueLicenseManagementContext.this, this));
                }

                public net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext.TrueLicenseManagerBuilder$TrueAuthenticationBuilder keyProtection(PasswordProtection passwordProtection) {
                    this.keyProtection = Optional.ofNullable(passwordProtection);
                    return this;
                }

                public net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext.TrueLicenseManagerBuilder$TrueAuthenticationBuilder loadFrom(Source source) {
                    this.source = Optional.ofNullable(source);
                    return this;
                }

                public net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext.TrueLicenseManagerBuilder$TrueAuthenticationBuilder loadFromResource(String string) {
                    return this.loadFrom(TrueLicenseManagementContext.this.resource(string));
                }

                public net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext.TrueLicenseManagerBuilder$TrueAuthenticationBuilder storeProtection(PasswordProtection passwordProtection) {
                    this.storeProtection = Optional.ofNullable(passwordProtection);
                    return this;
                }

                public net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext.TrueLicenseManagerBuilder$TrueAuthenticationBuilder storeType(String string) {
                    this.storeType = Optional.ofNullable(string);
                    return this;
                }
            }
        }

        /*
         * Signature claims super is net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext.TrueLicenseManagerBuilder<net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext.VendorTrueLicenseManagerBuilder>, not net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext$TrueLicenseManagerBuilder - discarding signature.
         */
        final class VendorTrueLicenseManagerBuilder
        extends TrueLicenseManagerBuilder
        implements VendorLicenseManagerBuilder {
            VendorTrueLicenseManagerBuilder() {
            }

            public VendorLicenseManager build() {
                return new TrueLicenseManagementParameters(TrueLicenseManagementContext.this, (TrueLicenseManagerBuilder)this).new TrueLicenseManagementParameters.TrueLicenseManager();
            }
        }

        /*
         * Signature claims super is net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext.TrueLicenseManagerBuilder<net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext.ConsumerTrueLicenseManagerBuilder>, not net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext$TrueLicenseManagerBuilder - discarding signature.
         */
        class ConsumerTrueLicenseManagerBuilder
        extends TrueLicenseManagerBuilder
        implements ConsumerLicenseManagerBuilder {
            ConsumerTrueLicenseManagerBuilder() {
            }

            public ConsumerLicenseManager build() {
                TrueLicenseManagementParameters trueLicenseManagementParameters = new TrueLicenseManagementParameters(TrueLicenseManagementContext.this, (TrueLicenseManagerBuilder)this);
                return this.parent.isPresent() ? trueLicenseManagementParameters.new TrueLicenseManagementParameters.ChainedTrueLicenseManager() : trueLicenseManagementParameters.new TrueLicenseManagementParameters.CachingTrueLicenseManager();
            }

            public net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext.ConsumerTrueLicenseManagerBuilder inject() {
                throw new UnsupportedOperationException();
            }

            public net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext.ConsumerTrueLicenseManagerBuilder.ParentConsumerTrueLicenseManagerBuilder parent() {
                return new ParentConsumerTrueLicenseManagerBuilder();
            }

            /*
             * Signature claims super is net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext.ConsumerTrueLicenseManagerBuilder, not net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext$ConsumerTrueLicenseManagerBuilder - discarding signature.
             */
            final class ParentConsumerTrueLicenseManagerBuilder
            extends ConsumerTrueLicenseManagerBuilder {
                ParentConsumerTrueLicenseManagerBuilder() {
                }

                @Override
                public net.truelicense.core.TrueLicenseApplicationContext$TrueLicenseManagementContext.ConsumerTrueLicenseManagerBuilder inject() {
                    return (ConsumerTrueLicenseManagerBuilder)ConsumerTrueLicenseManagerBuilder.this.parent(this.build());
                }
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    final class TrueLicenseManagementContextBuilder
    implements ContextProvider<TrueLicenseApplicationContext>,
    LicenseManagementContextBuilder {
        LicenseManagementAuthorization authorization = this.context().authorization();
        ClassLoaderProvider classLoaderProvider = this.context();
        Clock clock = this.context();
        Optional<LicenseInitialization> initialization = Optional.empty();
        LicenseFunctionComposition initializationComposition = LicenseFunctionComposition.decorate;
        String subject = TrueLicenseManagementContextBuilder._string#0();
        Optional<LicenseValidation> validation = Optional.empty();
        LicenseFunctionComposition validationComposition = LicenseFunctionComposition.decorate;

        TrueLicenseManagementContextBuilder() {
        }

        public LicenseManagementContextBuilder authorization(LicenseManagementAuthorization licenseManagementAuthorization) {
            this.authorization = Objects.requireNonNull(licenseManagementAuthorization);
            return this;
        }

        public LicenseManagementContextBuilder classLoaderProvider(ClassLoaderProvider classLoaderProvider) {
            this.classLoaderProvider = Objects.requireNonNull(classLoaderProvider);
            return null;
        }

        public LicenseManagementContextBuilder clock(Clock clock) {
            this.clock = Objects.requireNonNull(clock);
            return this;
        }

        public TrueLicenseApplicationContext context() {
            return TrueLicenseApplicationContext.this;
        }

        public LicenseManagementContextBuilder initialization(LicenseInitialization licenseInitialization) {
            this.initialization = Optional.ofNullable(licenseInitialization);
            return this;
        }

        public LicenseManagementContextBuilder initializationComposition(LicenseFunctionComposition licenseFunctionComposition) {
            this.initializationComposition = Objects.requireNonNull(licenseFunctionComposition);
            return this;
        }

        public LicenseManagementContextBuilder subject(String string) {
            this.subject = TrueLicenseApplicationContext.requireNonEmpty(string);
            return this;
        }

        public LicenseManagementContextBuilder validation(LicenseValidation licenseValidation) {
            this.validation = Optional.ofNullable(licenseValidation);
            return this;
        }

        public LicenseManagementContextBuilder validationComposition(LicenseFunctionComposition licenseFunctionComposition) {
            this.validationComposition = Objects.requireNonNull(licenseFunctionComposition);
            return this;
        }

        public LicenseManagementContext build() {
            return new TrueLicenseManagementContext(this);
        }

        private static /* synthetic */ String _string#0() {
            return new ObfuscatedString(new long[]{6346171214597364386L}).toString();
        }
    }

    final class CheckedPasswordProtection
    implements PasswordProtection {
        final PasswordProtection protection;

        CheckedPasswordProtection(PasswordProtection passwordProtection) {
            this.protection = passwordProtection;
        }

        public Password password(PasswordUsage passwordUsage) throws Exception {
            if (passwordUsage.equals((Object)PasswordUsage.WRITE)) {
                TrueLicenseApplicationContext.this.policy().check(this.protection);
            }
            return this.protection.password(passwordUsage);
        }
    }
}

