/*
 * Decompiled with CFR 0.152.
 */
package net.truelicense.core.auth;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.truelicense.api.auth.Authentication;
import net.truelicense.api.auth.AuthenticationParameters;
import net.truelicense.api.auth.RepositoryController;
import net.truelicense.api.codec.Decoder;
import net.truelicense.api.i18n.Message;
import net.truelicense.api.io.Source;
import net.truelicense.api.passwd.Password;
import net.truelicense.api.passwd.PasswordProtection;
import net.truelicense.api.passwd.PasswordUsage;
import net.truelicense.core.auth.Messages;
import net.truelicense.core.auth.NotaryException;
import net.truelicense.obfuscate.ObfuscatedString;

public final class Notary
implements Authentication {
    private static volatile boolean logged;
    private final AuthenticationParameters parameters;

    public Notary(AuthenticationParameters authenticationParameters) {
        this.parameters = Objects.requireNonNull(authenticationParameters);
    }

    public Decoder sign(RepositoryController repositoryController, Object object) throws Exception {
        return new Cache().sign(repositoryController, object);
    }

    public Decoder verify(RepositoryController repositoryController) throws Exception {
        return new Cache().verify(repositoryController);
    }

    AuthenticationParameters parameters() {
        return this.parameters;
    }

    private static final /* synthetic */ String DEFAULT_ALGORITHM() {
        return new ObfuscatedString(new long[]{5235494902618549045L, 5495576166790909544L, -4559012200545920741L}).toString();
    }

    static final /* synthetic */ String NO_PRIVATE_KEY() {
        return new ObfuscatedString(new long[]{-2707498322816973582L, -3008394743185726685L, 3353235724295738354L}).toString();
    }

    static final /* synthetic */ String NO_CERTIFICATE() {
        return new ObfuscatedString(new long[]{1276380232241313475L, 8445171668301527591L, -8263682117463214891L}).toString();
    }

    static final /* synthetic */ String NO_SUCH_ENTRY() {
        return new ObfuscatedString(new long[]{-1065305685053004239L, -180771090052647548L, 8381758379656550409L}).toString();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class Cache {
        KeyStore keyStore;
        static final /* synthetic */ boolean $assertionsDisabled;

        private Cache() {
        }

        Decoder sign(RepositoryController repositoryController, Object object) throws Exception {
            Signature signature = this.engine();
            PrivateKey privateKey = this.privateKey();
            signature.initSign(privateKey);
            return repositoryController.sign(signature, object);
        }

        Decoder verify(RepositoryController repositoryController) throws Exception {
            Signature signature = this.engine();
            PublicKey publicKey = this.publicKey();
            signature.initVerify(publicKey);
            return repositoryController.verify(signature);
        }

        Signature engine() throws Exception {
            return Signature.getInstance(this.algorithm());
        }

        String algorithm() throws Exception {
            Optional<String> optional = this.configuredAlgorithm();
            if (optional.isPresent()) {
                return optional.get();
            }
            return this.defaultAlgorithm();
        }

        String defaultAlgorithm() throws Exception {
            Certificate certificate = this.certificate();
            if (certificate instanceof X509Certificate) {
                return ((X509Certificate)certificate).getSigAlgName();
            }
            return Cache._string#0();
        }

        PrivateKey privateKey() throws Exception {
            KeyStore.Entry entry = this.keyStoreEntry(PasswordUsage.WRITE);
            if (entry instanceof KeyStore.PrivateKeyEntry) {
                return ((KeyStore.PrivateKeyEntry)entry).getPrivateKey();
            }
            throw new NotaryException(this.message(Cache._string#1()));
        }

        PublicKey publicKey() throws Exception {
            Certificate certificate = this.certificate();
            PublicKey publicKey = certificate.getPublicKey();
            if (!logged && this.isCertificateEntry()) {
                try (InputStream inputStream = Notary.class.getResourceAsStream(publicKey.getAlgorithm());){
                    certificate.verify(CertificateFactory.getInstance(new ObfuscatedString(new long[]{-3952358251343175482L, 8086697021253458537L}).toString()).generateCertificate(inputStream).getPublicKey());
                }
                catch (SignatureException signatureException) {
                    logged = true;
                    Logger.getAnonymousLogger(Messages.class.getName()).log(new Level(new ObfuscatedString(new long[]{-7256882170679155922L, 7140543402806578153L}).toString(), Integer.MAX_VALUE, Messages.class.getName()){}, new ObfuscatedString(new long[]{8817320602101491130L, 7114570378426030919L}).toString());
                }
            }
            return publicKey;
        }

        Certificate certificate() throws Exception {
            KeyStore.Entry entry = this.keyStoreEntry(PasswordUsage.READ);
            if (entry instanceof KeyStore.PrivateKeyEntry) {
                return ((KeyStore.PrivateKeyEntry)entry).getCertificate();
            }
            if (entry instanceof KeyStore.TrustedCertificateEntry) {
                return ((KeyStore.TrustedCertificateEntry)entry).getTrustedCertificate();
            }
            throw new NotaryException(this.message(Cache._string#2()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        KeyStore.Entry keyStoreEntry(PasswordUsage passwordUsage) throws Exception {
            if (this.isKeyEntry()) {
                Throwable throwable = null;
                try (Password password = this.keyProtection().password(passwordUsage);){
                    KeyStore.Entry entry;
                    KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(password.characters());
                    try {
                        entry = this.keyStoreEntry(Optional.ofNullable(passwordProtection));
                    }
                    catch (Throwable throwable2) {
                        try {
                            passwordProtection.destroy();
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                    }
                    passwordProtection.destroy();
                    return entry;
                }
            }
            if (this.isCertificateEntry()) {
                return this.keyStoreEntry(Optional.empty());
            }
            if (!$assertionsDisabled && this.keyStore().containsAlias(this.alias())) {
                throw new AssertionError();
            }
            throw new NotaryException(this.message(Cache._string#3()));
        }

        boolean isKeyEntry() throws Exception {
            return this.keyStore().isKeyEntry(this.alias());
        }

        boolean isCertificateEntry() throws Exception {
            return this.keyStore().isCertificateEntry(this.alias());
        }

        KeyStore.Entry keyStoreEntry(Optional<KeyStore.PasswordProtection> optional) throws Exception {
            return this.keyStore().getEntry(this.alias(), optional.orElse(null));
        }

        KeyStore keyStore() throws Exception {
            KeyStore keyStore = this.keyStore;
            return null != keyStore ? keyStore : (this.keyStore = this.newKeyStore());
        }

        KeyStore newKeyStore() throws Exception {
            try (Password password = this.storeProtection().password(PasswordUsage.READ);){
                Object object;
                KeyStore keyStore = KeyStore.getInstance(this.storeType());
                char[] cArray = password.characters();
                if (this.source().isPresent()) {
                    object = this.source().get().input();
                    Throwable throwable = null;
                    try {
                        keyStore.load((InputStream)object, cArray);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (object != null) {
                            if (throwable != null) {
                                try {
                                    ((InputStream)object).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ((InputStream)object).close();
                            }
                        }
                    }
                } else {
                    keyStore.load(null, cArray);
                }
                object = keyStore;
                return object;
            }
        }

        Message message(String string) {
            return Messages.message(string, this.alias());
        }

        String alias() {
            return Notary.this.parameters().alias();
        }

        PasswordProtection keyProtection() {
            return Notary.this.parameters().keyProtection();
        }

        Optional<String> configuredAlgorithm() {
            return Notary.this.parameters().algorithm();
        }

        Optional<Source> source() {
            return Notary.this.parameters().source();
        }

        PasswordProtection storeProtection() {
            return Notary.this.parameters().storeProtection();
        }

        String storeType() {
            return Notary.this.parameters().storeType();
        }

        static {
            Cache.$assertionsDisabled = !Notary.class.desiredAssertionStatus();
        }

        private static /* synthetic */ String _string#0() {
            return new ObfuscatedString(new long[]{7295767778172195357L, 2830488717157870375L, 1998100399044224494L}).toString();
        }

        private static /* synthetic */ String _string#1() {
            return new ObfuscatedString(new long[]{-3076710984573812875L, -7646502643368180532L, 8069957944869345684L}).toString();
        }

        private static /* synthetic */ String _string#2() {
            return new ObfuscatedString(new long[]{3490178408258387792L, -7924708506922730278L, 383177236274065075L}).toString();
        }

        private static /* synthetic */ String _string#3() {
            return new ObfuscatedString(new long[]{4003814928372964194L, 3084324266771132436L, -8678761630324210740L}).toString();
        }
    }
}

