/*
 * Decompiled with CFR 0.152.
 */
package net.truelicense.core.crypto;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import net.truelicense.api.crypto.EncryptionParameters;
import net.truelicense.api.io.Transformation;
import net.truelicense.api.passwd.Password;
import net.truelicense.api.passwd.PasswordProtection;
import net.truelicense.api.passwd.PasswordUsage;

public abstract class BasicEncryption
implements Transformation {
    private final EncryptionParameters parameters;

    protected BasicEncryption(EncryptionParameters encryptionParameters) {
        this.parameters = Objects.requireNonNull(encryptionParameters);
    }

    private PasswordProtection protection() {
        return this.parameters.protection();
    }

    protected final String algorithm() {
        return this.parameters.algorithm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final SecretKey secretKey(PasswordUsage passwordUsage) throws Exception {
        Throwable throwable = null;
        try (Password password = this.protection().password(passwordUsage);){
            PBEKeySpec pBEKeySpec = new PBEKeySpec(password.characters());
            try {
                SecretKey secretKey = SecretKeyFactory.getInstance(this.algorithm()).generateSecret(pBEKeySpec);
                pBEKeySpec.clearPassword();
                return secretKey;
            }
            catch (Throwable throwable2) {
                try {
                    pBEKeySpec.clearPassword();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
        }
    }

    protected static <V> V wrap(Callable<V> callable) throws IOException {
        try {
            return callable.call();
        }
        catch (IOException | RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }
}

