/*
 * Decompiled with CFR 0.152.
 */
package net.truelicense.core.passwd;

import java.util.Arrays;
import java.util.Objects;
import net.truelicense.api.passwd.Password;
import net.truelicense.api.passwd.PasswordProtection;
import net.truelicense.api.passwd.PasswordUsage;
import net.truelicense.obfuscate.ObfuscatedString;

public final class ObfuscatedPasswordProtection
implements PasswordProtection {
    private final ObfuscatedString os;

    public ObfuscatedPasswordProtection(ObfuscatedString obfuscatedString) {
        this.os = Objects.requireNonNull(obfuscatedString);
    }

    public Password password(PasswordUsage passwordUsage) {
        return new ObfuscatedPassword();
    }

    private final class ObfuscatedPassword
    implements Password {
        final char[] characters;

        private ObfuscatedPassword() {
            this.characters = ObfuscatedPasswordProtection.this.os.toCharArray();
        }

        public char[] characters() {
            return this.characters;
        }

        public void close() {
            Arrays.fill(this.characters, '\u0000');
        }
    }
}

