/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.springframework.addons.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.unicon.springframework.addons.properties.DelegatingProperties;
import net.unicon.springframework.addons.properties.PropertiesReloadedEvent;
import net.unicon.springframework.addons.properties.ReloadableProperties;
import net.unicon.springframework.addons.properties.ReloadablePropertiesListener;

public class ReloadablePropertiesBase
extends DelegatingProperties
implements ReloadableProperties {
    private List<ReloadablePropertiesListener> listeners = new ArrayList<ReloadablePropertiesListener>();
    private Properties internalProperties;

    public void setListeners(List listeners) {
        this.listeners = listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Properties getDelegate() {
        ReloadablePropertiesBase reloadablePropertiesBase = this;
        synchronized (reloadablePropertiesBase) {
            return this.internalProperties;
        }
    }

    @Override
    public Properties getProperties() {
        return this.getDelegate();
    }

    @Override
    public void addReloadablePropertiesListener(ReloadablePropertiesListener l) {
        this.listeners.add(l);
    }

    @Override
    public boolean removeReloadablePropertiesListener(ReloadablePropertiesListener l) {
        return this.listeners.remove(l);
    }

    protected void notifyPropertiesChanged(Properties oldProperties) {
        PropertiesReloadedEvent event = new PropertiesReloadedEvent(this, oldProperties);
        for (ReloadablePropertiesListener listener : this.listeners) {
            listener.propertiesReloaded(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setProperties(Properties properties) {
        Properties oldProperties = this.internalProperties;
        ReloadablePropertiesBase reloadablePropertiesBase = this;
        synchronized (reloadablePropertiesBase) {
            this.internalProperties = properties;
        }
        this.notifyPropertiesChanged(oldProperties);
    }
}

