/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.springframework.addons.properties;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.unicon.springframework.addons.properties.ReconfigurableBean;
import net.unicon.springframework.addons.properties.ReloadablePropertiesBase;
import net.unicon.springframework.addons.properties.ReloadablePropertiesListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.core.io.Resource;

public class ReloadablePropertiesFactoryBean
extends PropertiesFactoryBean
implements DisposableBean {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Resource[] locations;
    private long[] lastModified;
    private List<ReloadablePropertiesListener> preListeners;
    private ReloadablePropertiesBase reloadableProperties;

    public void setLocation(Resource location) {
        this.setLocations(new Resource[]{location});
    }

    public void setLocations(Resource[] locations) {
        this.locations = locations;
        this.lastModified = new long[locations.length];
        super.setLocations(locations);
    }

    protected Resource[] getLocations() {
        return this.locations;
    }

    public void setListeners(List listeners) {
        this.preListeners = new ArrayList<ReloadablePropertiesListener>();
        for (Object o : listeners) {
            this.preListeners.add((ReloadablePropertiesListener)o);
        }
    }

    protected Object createInstance() throws IOException {
        if (!this.isSingleton()) {
            throw new RuntimeException("ReloadablePropertiesFactoryBean only works as singleton");
        }
        this.reloadableProperties = new ReloadablePropertiesImpl();
        if (this.preListeners != null) {
            this.reloadableProperties.setListeners(this.preListeners);
        }
        this.reload(true);
        return this.reloadableProperties;
    }

    public void destroy() throws Exception {
        this.reloadableProperties = null;
    }

    protected void reload(boolean forceReload) throws IOException {
        boolean reload = forceReload;
        int i = 0;
        while (i < this.locations.length) {
            block7: {
                File file;
                Resource location = this.locations[i];
                try {
                    file = location.getFile();
                }
                catch (IOException iOException) {
                    break block7;
                }
                try {
                    long l = file.lastModified();
                    if (l > this.lastModified[i]) {
                        this.lastModified[i] = l;
                        reload = true;
                    }
                }
                catch (Exception e) {
                    if (!this.log.isDebugEnabled()) break block7;
                    this.log.debug("can't determine modification time of " + file + " for " + location, (Throwable)e);
                }
            }
            ++i;
        }
        if (reload) {
            this.doReload();
        }
    }

    private void doReload() throws IOException {
        this.reloadableProperties.setProperties(this.mergeProperties());
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    class ReloadablePropertiesImpl
    extends ReloadablePropertiesBase
    implements ReconfigurableBean {
        ReloadablePropertiesImpl() {
        }

        @Override
        public void reloadConfiguration() throws Exception {
            ReloadablePropertiesFactoryBean.this.reload(false);
        }
    }
}

