/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.springframework.addons.security.core.userdetails;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public final class JsonDaoImpl
implements UserDetailsService {
    private final Logger logger = LoggerFactory.getLogger(JsonDaoImpl.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private Map<String, User> usersMap = new HashMap<String, User>();
    private final Resource usersConfigFile;

    public JsonDaoImpl(Resource users) {
        this.usersConfigFile = users;
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        this.loadUsers();
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        return (UserDetails)this.usersMap.get(username);
    }

    private void loadUsers() {
        try {
            if (this.usersConfigFile.exists() && this.usersConfigFile.getFile().length() > 0L) {
                Set users = (Set)this.objectMapper.readValue(this.usersConfigFile.getFile(), (TypeReference)new TypeReference<Set<SimpleUser>>(){});
                for (SimpleUser u : users) {
                    this.usersMap.put(u.getUsername(), new User(u.getUsername(), u.getPassword(), u.getAuthorities()));
                }
                this.logger.debug("Loaded user definitions from {}", (Object)this.usersConfigFile.getFilename());
            } else {
                this.logger.warn("The resource {} is not found, or is empty.");
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static class SimpleUser {
        private String username;
        private String password;
        private Set<SimpleGrantedAuthority> authorities = new HashSet<SimpleGrantedAuthority>();

        public SimpleUser() {
        }

        public SimpleUser(String username, String password, Set<SimpleGrantedAuthority> authorities) {
            this.username = username;
            this.password = password;
            this.authorities = authorities;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public Set<SimpleGrantedAuthority> getAuthorities() {
            return this.authorities;
        }

        public void setAuthorities(Set<SimpleGrantedAuthority> authorities) {
            this.authorities = authorities;
        }
    }
}

