package net.veloxity.sdk.hybrid_common

/**
 * Created by F.K. on 30.09.2023.
 *
 */
object Command {
    val ACTIVATION_STATUS by lazy { "save_data_usage_status"}
    val AWARENESS by lazy { "save_awareness_api_data"}
    val EVENT_LIST by lazy { "determine_rules"}
    val PN_TOKEN by lazy { "register_for_push_notify"}
    val RTCO_NOTIFY by lazy { "save_geofence_action"}
    val RTCO_OFFER_STATUS by lazy { "save_offer_status"}
    val SAVE_EVENT by lazy { "save_event_notify"}
    val SAVE_SPEED_INFO by lazy { "save_speed_info"}
    val SYNTH_TICK_RESULT by lazy { "save_speed_test_tick_result"}
    val SYNTH_RESULT by lazy { "save_speed_test_result"}
    val TRACE_ROUTE by lazy { "save_traceroute_result"}
    val OFFLINE_EVENT by lazy { "offline_event"}
    val CAPTIVE_PORTAL by lazy { "captive_portal"}
    val SAVE_LOCATION by lazy { "save_location"}
    val SAVE_SENSOR_DATA by lazy { "save_sensor_data"}
    val VSKOR_DATA by lazy { "VSKOR_DATA"}
    val IP_ACTIVITY by lazy { "ip_activity"}
    object AppEvent {
        val APP_ACTIVITY by lazy { "in_app_activity"}
        val SAVE_PLAYLIST_ALL by lazy { "save_playlist_all"}
        /** After separating the user and system app list
         * we start using "SAVE_USER_APP_LIST" instead of "SAVE_PLAYLIST_ALL"  */
        val SAVE_USER_APP_LIST by lazy { "save_user_app_list"}
        val SAVE_SYSTEM_APP_LIST by lazy { "save_system_app_list"}
    }
    object DeviceEvent {
        val DEVICE_PLAYLIST_ADD by lazy { "add_to_playlist"}
        val DEVICE_PLAYLIST_REMOVE by lazy { "remove_from_playlist"}
        val DEVICE_PLAYLIST_UPDATE by lazy { "update_playlist"}
        val DEVICE_REGISTER by lazy { "REGISTER_DEVICE"}
        val DEVICE_SETTINGS by lazy { "get_settings"}
        val DEVICE_STATUS by lazy { "get_device_status"}
        val SYNTH_NOTIFY_RECEIVE by lazy { "save_device_synth_transaction"}
        val UPDATE_FEATURE_VAL by lazy { "save_device_feature_change"}
    }
    object UserEvent {
        val USER_CUSTOMIZE by lazy { "save_custom_data"}
        val USER_REGISTER by lazy { "save_device_private_data"}
    }
    object BLEvent {
        val PAIRED_BLUETOOTH_DEVICES by lazy { "paired_bluetooth_devices"}
        val SCAN_BLE_DEVICES by lazy { "scanned_devices"}
        val BLE_PROXIMITY by lazy { "bluetooth_proximity"}
        val BLE_ENTER by lazy { "bluetooth_enter"}
        val BLE_EXIT by lazy { "bluetooth_exit"}
    }
}