package net.veloxity.sdk.hybrid_common

import android.content.Context
import android.content.pm.PackageManager
import androidx.core.app.ActivityCompat
import androidx.core.content.ContextCompat

/**
 * Created by F.K. on 20.08.2023.
 *
 */

fun Context.hasPermissionOf(permission: String) =
    ActivityCompat.checkSelfPermission(this, permission) == PackageManager.PERMISSION_GRANTED

fun Context.hasNotPermissionOf(permission: String) =
    ActivityCompat.checkSelfPermission(this, permission) != PackageManager.PERMISSION_GRANTED

fun Context.hasPermissions(permissions: Array<String>): Boolean {
    for (permission in permissions) {
        if (this.hasNotPermissionOf(permission)) return false
    }
    return true
}
