package net.veloxity.sdk.hybrid_common

import java.text.SimpleDateFormat
import java.util.Date
import java.util.Locale

/**
 * Created by F.K. on 20.08.2023.
 *
 */

internal val dateFormatter = SimpleDateFormat("dd-MM-yyyy", Locale("TR"))

fun Date.isEqual(yesterday: Date) = dateFormatter.format(this)
    .equals(dateFormatter.format(yesterday))

fun Date.todayDate(): String = dateFormatter.format(this)

fun String.isTodayDate() =
    if (this.isEmpty()) false
    else {
        try {
            val todayDate = dateFormatter.parse(this)
            todayDate?.let { todayDate -> Date().isEqual(todayDate) } ?: false
        } catch (e: Exception) {
            false
        }
    }
