package net.veloxity.sdk.hybrid_common

/**
 * Created by F.K. on 6.09.2023.
 *
 */
fun String.startsWithAny(vararg prefixes: String): Boolean {
    return prefixes.any { this.startsWith(it) }
}

fun getLoadedPackageVersions(vararg includePrefixes: String): String {
    val packages = Package.getPackages()
    val filteredPackages = packages.filter {
        it.name.startsWithAny(*includePrefixes)
    }
    val versionsText = filteredPackages
        .map { "\t${it.name}: ${it.implementationTitle} v(${it.implementationVersion}) by ${it.implementationVendor}" }
        .sorted()
        .joinToString("\n")
    return "Versions of ${filteredPackages.size} loaded packages:\n${versionsText}"
}