package net.veloxity.sdk.hybrid_common

import android.content.Context
import android.os.Build
import android.text.TextUtils
import android.util.Pair
import net.veloxity.sdk.hybrid_common.LogUtils.LOGD
import net.veloxity.sdk.hybrid_common.LogUtils.LOGE
import net.veloxity.sdk.hybrid_common.LogUtils.makeLogTag
import org.json.JSONObject

/**
 * Created by F.K. on 1.10.2023.
 *
 */
object CommonSettings {
    private val TAG: String by lazy { makeLogTag("CommonSettings")}

    var UPLOAD_ENCRYPT_RULE = true
    
    var AND_REMOVE_ALL_FENCES_BEFORE_UPDATE = true
    var AND_GEOFENCE_FLOWER_ENABLED = true

    var AND_SAVE_COLLECT_DATA = true
    var AND_AGGREGATION_ENABLED = true
    var AND_AGGREGATION_ENABLED_ROAMING = true
    var AND_AGGREGATION_ENABLED_MOBILE = true
    var AND_AGGREGATION_ENABLED_WIFI = true
    var AND_ANALYSIS_UPLOAD_ENABLED = true
    var AND_ANALYSIS_UPLOAD_ENABLED_ROAMING = false
    var AND_ANALYSIS_UPLOAD_ENABLED_MOBILE = false
    var AND_ANALYSIS_UPLOAD_ENABLED_WIFI = true
    var AND_CHECK_WIFI_JOIN = true
    var AND_INDOOR_DETECT_ENABLED = false
    var AND_IN_APP_HISTOGRAM_ENABLED = false
    var AND_APP_UPLOADER_ENABLED = true
    var AND_GEOFENCE_ENABLED = false
    var AND_LOCATION_DETECTION_ENABLED = true
    var AND_LOCATION_REVERSE_GEO_ENABLED = true
    var AND_LOCATION_ALTITUDE_SPEED_ENABLED = true
    var AND_PROCESS_DATA_CON_READ_ENABLED = true
    var AND_PROCESS_RES_USAGE_ENABLED = true
    var AND_READ_PRIVATE_DEVICE_DATA = false
    var AND_WIFI_NEIGH_LIST_ENABLED = false
    var AND_WIFI_NEIGH_SERVICE_ENABLED = false
    var AND_FEATURE_WIFI_AP_STATE_ENABLED = true
    var AND_FEATURE_WIFI_STATE_ENABLED = true
    var AND_FEATURE_BLUETOOTH_STATE_ENABLED = true
    var AND_FEATURE_BLUETOOTH_CONNECTED = true
    var AND_FEATURE_RINGER_MODE_ENABLED = true
    var AND_FEATURE_AIRPLANE_MODE_ENABLED = true
    var AND_FEATURE_LOCATION_GPS_ENABLED = true
    var AND_FEATURE_HEADPHONE_PLUG_ENABLED = true
    var AND_FEATURE_DEVICE_STORAGE_LOW = true
    var AND_FEATURE_POWER_CONNECTED_ENABLED = true
    var AND_FEATURE_DOCK_CONNECTED = true
    var AND_MEMORY_STORAGE_INFO_ENABLED = true
    var AND_OFFLINE_SYSTEM_ENABLED = false
    var AND_AWARENESS_ENABLED = false
    var AND_FCM_UPSTREAM_ENABLED = false
    var IS_EVENT_RULE_LIST_ENABLED = false
    var IS_MOBILE_UPLOAD_ENABLED = false
    var AND_WIFI_NEIGH_SERVICE_SIZE = 3
    var AND_WIFI_AREA_SIGNAL_THRESHOLD = -70
    var AND_CLEAR_NOTIFIED_WIFI_DURATION: Long = 86400000
    var AND_CLEAR_NOTIFIED_WIFI_APP_DURATION: Long = 86400000
    var AND_CLEAR_NOTIFIED_ROAMING_DURATION: Long = 86400000
    var AND_CLEAR_NOTIFIED_BACKGROUND_SYNC_DURATION: Long = 86400000
    var AND_CLEAR_NOTIFIED_APP_ACTIVITY_DURATION: Long = 86400000
    var AND_CHECK_MASTER_INSTANCE_ALIVE: Long = 14400000
    var AND_MAX_CPU_WAIT_THR: Long = 30000
    var AND_REGISTER_RETRY_INTERVAL: Long = 600000
    var AND_SETTINGS_DOWNLOADER_DURATION: Long = 3600000
    var AND_SIGNAL_STRENGTH_UPDATE_THRESHOLD: Long = 180000
    var AND_WIFI_JOIN_APP_LIST_THRESHOLD: Long = 60000
    var DATA_COLLECT_DURATION: Long = 5000
    var DATA_UPLOADER_DURATION: Long = 600000
    var DATA_AGGREGATION_DURATION: Long = 600000
    var AND_APP_UPLOADER_DURATION: Long = 86400000 // Daily

    var AND_SYSTEM_APP_UPLOADER_DURATION = (86400000 * 7).toLong() // Weekly
    var MAX_GLOBAL_DATA_CONSUMPTION: Long = 51200
    var PROCESS_RESOURCE_READ_THRESHOLD: Long = 30000
    var RULE_DOWNLOADER_DURATION: Long = 900000
    var AND_DOWNLOAD_TEST_MAX_LIMIT = (50 * 1024 * 1024).toLong()
    var AND_UPLOAD_TEST_MAX_LIMIT = (50 * 1024 * 1024).toLong()

    var AND_LOCATION_INFO_UPLOAD_INTERVAL = (2 * 60 * 1000).toLong() // seconds -> 2 minutes
    var AND_LOCATION_INFO_UPLOAD_DISPLACEMENT: Long = 0 // meters


    var AND_LOCATION_INFO_UPLOAD_INTERVAL_PDU: Long = 300000 // seconds -> 5 minutes

    var AND_LOCATION_INFO_UPLOAD_DISPLACEMENT_PDU: Long = 0 // meters


    // 100 PRIORITY_HIGH_ACCURACY
    // 102 PRIORITY_BALANCED_POWER_ACCURACY
    // 104 PRIORITY_LOW_POWER
    // 105 PRIORITY_NO_POWER

    // 100 PRIORITY_HIGH_ACCURACY
    // 102 PRIORITY_BALANCED_POWER_ACCURACY
    // 104 PRIORITY_LOW_POWER
    // 105 PRIORITY_NO_POWER
//    var AND_LOCATION_ACCURACY: Int = LocationRequest.PRIORITY_BALANCED_POWER_ACCURACY
//    var AND_LOCATION_ACCURACY_PDU: Int = LocationRequest.PRIORITY_BALANCED_POWER_ACCURACY

    // Sensors
    var AND_SENSORS_ENABLED = false

    // BleConfiguration
    var AND_BLE_PROXIMITY_LISTENING_ENABLED = false
    var AND_BLE_ADVERTISING_UDID = ""

    var AND_BLE_ADVERTISING_ENABLED = false
    var AND_BLE_BEACON_LISTENING_ENABLED = false
    var AND_BLE_BEACON_LOST_DURATION_MS = 60000
    var AND_BLE_LISTENING_UDID1 = ""
    var AND_BLE_LISTENING_UDID2 = ""
    var AND_BLE_LISTENING_UDID3 = ""
    var AND_BLE_LISTENING_UDID4 = ""
    var AND_BLE_PROXIMITY_REPORT_FLATTEN_COUNT = 10
    var AND_BLE_PROXIMITY_REPORT_ENOUGH_REPORT_COUNT = 3
    var AND_BLE_PROXIMITY_REPORT_MAX_REPORT_COUNT = 30
    var AND_BLE_PROXIMITY_REPORT_CREATE_INTERVAL = 5 * 1000

    var AND_DATA_COLLECTION_INTERVAL = 60 // 60 minutes

    var AND_DATA_COLLECTION_FLEX_INTERVAL = 30 // 30 Minutes


    var AND_IP_ACTIVITY_INTERVAL = 60 // 60 minutes

    var AND_IP_ACTIVITY_FLEX_INTERVAL = 30 // 30 Minutes


    var AND_BLE_DEVICES_INTERVAL = 60 // 60 minutes

    var AND_BLE_DEVICES_FLEX_INTERVAL = 30 // 30 Minutes


    var AND_DATA_UPLOAD_ENDPOINT: String? = null
    var isPrivateDataSent = false

    fun parseSettings(
        context: Context,
        settings: String,
        isPersistToDb: Boolean,
        isFromWorker: Boolean
    ): Boolean {
        LOGD(TAG, "ParseValue:\r\n $settings")
        if (!TextUtils.isEmpty(settings)) {
            try {
                val json: JSONObject
                /*if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                    try {
                        LOGE(TAG, "THE_CHECK 1")
                        if (isPersistToDb) {
                            LOGE(TAG, "THE_CHECK 2")
                            SettingsRulesTable.insertSettingsJson(context, settings)
                            LOGE(TAG, "THE_CHECK 3")
                            json = JSONObject(settings)
                            LOGE(TAG, "THE_CHECK 4")
                        } else {
                            LOGE(TAG, "THE_CHECK 5")
                            if (Utils.isDemo()) {
                                WorkerTable.insert(context, "Load settings from database")
                            }
                            val dbSettings: Pair<String, String> =
                                SettingsRulesTable.getSettingsColumns(context)
                            if (TextUtils.isEmpty(dbSettings.first) || TextUtils.isEmpty(dbSettings.second)) {
                                LOGE(TAG, "THE_CHECK 6")
                                return false
                            }
                            json = JSONObject(dbSettings.first)
                            LOGE(TAG, "THE_CHECK 7")
                            WebService.Companion.setETagForSettings(dbSettings.second)
                        }
                    } catch (e: Exception) {
                        LOGE(TAG,
                            "Exception in parseSettings --> ",
                            e.toString()
                        )
                        if (Utils.isDemo()) {
                            WorkerTable.insert(context, "Exception in parseSettings --> $e")
                        }
                        return false
                    }
                } else {
                    json = try {
                        JSONObject(settings)
                    } catch (e: Exception) {
                        LOGE(TAG,
                            "Exception in parseSettings",
                            e.toString()
                        )
                        return false
                    }
                }*/
                json = try {
                    JSONObject(settings)
                } catch (e: Exception) {
                    LOGE(TAG,
                        "Exception in parseSettings",
                        e.toString()
                    )
                    return false
                }
                val nameValues = json.optJSONArray("responseParameters")
                for (i in 0 until nameValues.length()) {
                    val nameValue = nameValues.optJSONObject(i)
                    when (nameValue.optString("name")) {
                        "AND_GEOFENCE_FLOWER_ENABLED" -> AND_GEOFENCE_FLOWER_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_REMOVE_ALL_FENCES_BEFORE_UPDATE" -> AND_REMOVE_ALL_FENCES_BEFORE_UPDATE =
                            nameValue.optInt("value") == 1

                        "AND_SENSORS_ENABLED" -> AND_SENSORS_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_BLE_BEACON_LOST_DURATION_MS" -> AND_BLE_BEACON_LOST_DURATION_MS =
                            nameValue.optInt("value")

                        "AND_BLE_ADVERTISING_UDID" -> AND_BLE_ADVERTISING_UDID =
                            nameValue.optString("value")

                        "AND_BLE_PROXIMITY_LISTENING_ENABLED" -> AND_BLE_PROXIMITY_LISTENING_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_BLE_ADVERTISING_ENABLED" -> AND_BLE_ADVERTISING_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_BLE_BEACON_LISTENING_ENABLED" -> AND_BLE_BEACON_LISTENING_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_BLE_LISTENING_UDID1" -> AND_BLE_LISTENING_UDID1 =
                            nameValue.optString("value")

                        "AND_BLE_LISTENING_UDID2" -> AND_BLE_LISTENING_UDID2 =
                            nameValue.optString("value")

                        "AND_BLE_LISTENING_UDID3" -> AND_BLE_LISTENING_UDID3 =
                            nameValue.optString("value")

                        "AND_BLE_LISTENING_UDID4" -> AND_BLE_LISTENING_UDID4 =
                            nameValue.optString("value")

                        "AND_BLE_PROXIMITY_REPORT_FLATTEN_COUNT" -> AND_BLE_PROXIMITY_REPORT_FLATTEN_COUNT =
                            nameValue.optInt("value")

                        "AND_BLE_PROXIMITY_REPORT_ENOUGH_REPORT_COUNT" -> AND_BLE_PROXIMITY_REPORT_ENOUGH_REPORT_COUNT =
                            nameValue.optInt("value")

                        "AND_BLE_PROXIMITY_REPORT_MAX_REPORT_COUNT" -> AND_BLE_PROXIMITY_REPORT_MAX_REPORT_COUNT =
                            nameValue.optInt("value")

                        "AND_BLE_PROXIMITY_REPORT_CREATE_INTERVAL" -> AND_BLE_PROXIMITY_REPORT_CREATE_INTERVAL =
                            nameValue.optInt("value")

                        "AND_SAVE_COLLECT_DATA" -> AND_SAVE_COLLECT_DATA =
                            nameValue.optInt("value") == 1

                        "ConnAnalysisInterval" -> DATA_COLLECT_DURATION = nameValue.optLong("value")
                        "ConnAnalysisPackInterval" -> DATA_AGGREGATION_DURATION =
                            nameValue.optLong("value")

                        "ConnAnalysisUploadInterval" -> DATA_UPLOADER_DURATION =
                            nameValue.optLong("value")

                        "AD_RULE_CONF_REFRESH_INTERVAL" -> RULE_DOWNLOADER_DURATION =
                            nameValue.optLong("value")

                        "AND_PROCESS_EVENT_RULES" -> IS_EVENT_RULE_LIST_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_MOBILE_DATA_TRANSFER_ENABLED" -> IS_MOBILE_UPLOAD_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_LOCATION_DETECTION_ENABLED" -> AND_LOCATION_DETECTION_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_LOCATION_REVERSE_GEO_ENABLED" -> AND_LOCATION_REVERSE_GEO_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_LOCATION_ALTITUDE_SPEED_ENABLED" -> AND_LOCATION_ALTITUDE_SPEED_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_PROCESS_DATA_CON_READ_ENABLED" -> AND_PROCESS_DATA_CON_READ_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_PROCESS_RES_USAGE_ENABLED" -> AND_PROCESS_RES_USAGE_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_WIFI_NEIGH_LIST_ENABLED" -> AND_WIFI_NEIGH_LIST_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_WIFI_NEIGH_SERVICE_ENABLED" -> AND_WIFI_NEIGH_SERVICE_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_FEATURE_WIFI_AP_STATE_ENABLED" -> AND_FEATURE_WIFI_AP_STATE_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_FEATURE_WIFI_STATE_ENABLED" -> AND_FEATURE_WIFI_STATE_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_FEATURE_BLUETOOTH_STATE_ENABLED" -> AND_FEATURE_BLUETOOTH_STATE_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_FEATURE_BLUETOOTH_CONNECTED" -> AND_FEATURE_BLUETOOTH_CONNECTED =
                            nameValue.optInt("value") == 1

                        "AND_FEATURE_RINGER_MODE_ENABLED" -> AND_FEATURE_RINGER_MODE_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_FEATURE_AIRPLANE_MODE_ENABLED" -> AND_FEATURE_AIRPLANE_MODE_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_FEATURE_LOCATION_GPS_ENABLED" -> AND_FEATURE_LOCATION_GPS_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_FEATURE_HEADPHONE_PLUG_ENABLED" -> AND_FEATURE_HEADPHONE_PLUG_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_FEATURE_DEVICE_STORAGE_LOW" -> AND_FEATURE_DEVICE_STORAGE_LOW =
                            nameValue.optInt("value") == 1

                        "AND_FEATURE_POWER_CONNECTED_ENABLED" -> AND_FEATURE_POWER_CONNECTED_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_FEATURE_DOCK_CONNECTED" -> AND_FEATURE_DOCK_CONNECTED =
                            nameValue.optInt("value") == 1

                        "AND_MEMORY_STORAGE_INFO_ENABLED" -> AND_MEMORY_STORAGE_INFO_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_OFFLINE_SYSTEM_ENABLED" -> AND_OFFLINE_SYSTEM_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_AWARENESS_ENABLED" -> AND_AWARENESS_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_GCM_UPSTREAM_ENABLED" -> AND_FCM_UPSTREAM_ENABLED =
                            nameValue.optInt("value") == 1

                        "UPLOAD_ENCRYPT_RULE" -> UPLOAD_ENCRYPT_RULE =
                            nameValue.optInt("value") == 1

                        "AND_GLOB_DATA_USAGE_THRESHOLD" -> MAX_GLOBAL_DATA_CONSUMPTION =
                            nameValue.optLong("value")

                        "AND_PROCESS_RESOURCE_READ_THRESHOLD" -> PROCESS_RESOURCE_READ_THRESHOLD =
                            nameValue.optLong("value")

                        "AND_CHECK_WIFI_JOIN" -> AND_CHECK_WIFI_JOIN =
                            nameValue.optInt("value") == 1

                        "AND_AGGREGATION_ENABLED" -> AND_AGGREGATION_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_AGGREGATION_ENABLED_WIFI" -> AND_AGGREGATION_ENABLED_WIFI =
                            nameValue.optInt("value") == 1

                        "AND_AGGREGATION_ENABLED_ROAMING" -> AND_AGGREGATION_ENABLED_ROAMING =
                            nameValue.optInt("value") == 1

                        "AND_AGGREGATION_ENABLED_MOBILE" -> AND_AGGREGATION_ENABLED_MOBILE =
                            nameValue.optInt("value") == 1

                        "AND_ANALYSIS_UPLOAD_ENABLED" -> AND_ANALYSIS_UPLOAD_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_ANALYSIS_UPLOAD_ENABLED_WIFI" -> AND_ANALYSIS_UPLOAD_ENABLED_WIFI =
                            nameValue.optInt("value") == 1

                        "AND_ANALYSIS_UPLOAD_ENABLED_MOBILE" -> AND_ANALYSIS_UPLOAD_ENABLED_MOBILE =
                            nameValue.optInt("value") == 1

                        "AND_ANALYSIS_UPLOAD_ENABLED_ROAMING" -> AND_ANALYSIS_UPLOAD_ENABLED_ROAMING =
                            nameValue.optInt("value") == 1

                        "AND_APP_UPLOADER_ENABLED" -> AND_APP_UPLOADER_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_GEOFENCE_ENABLED" -> AND_GEOFENCE_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_SETTINGS_DOWNLOADER_DURATION" -> AND_SETTINGS_DOWNLOADER_DURATION =
                            nameValue.optLong("value")

                        "AND_SIGNAL_STRENGTH_UPDATE_THRESHOLD" -> AND_SIGNAL_STRENGTH_UPDATE_THRESHOLD =
                            nameValue.optLong("value")

                        "AND_MAX_CPU_WAIT_THR" -> AND_MAX_CPU_WAIT_THR = nameValue.optLong("value")
                        "AND_WIFI_AREA_SIGNAL_THRESHOLD" -> AND_WIFI_AREA_SIGNAL_THRESHOLD =
                            nameValue.optInt("value")

                        "AND_WIFI_NEIGH_SERVICE_SIZE" -> AND_WIFI_NEIGH_SERVICE_SIZE =
                            nameValue.optInt("value")

                        "AND_READ_PRIVATE_DEVICE_DATA" -> {
                            AND_READ_PRIVATE_DEVICE_DATA = nameValue.optInt("value") == 1
                            if (AND_READ_PRIVATE_DEVICE_DATA && !isPrivateDataSent && !isFromWorker) {
//                                sendPrivateData(context)
                            }
                        }

                        "AND_DATA_UPLOAD_ENDPOINT" -> AND_DATA_UPLOAD_ENDPOINT =
                            nameValue.optString("value")

                        "AND_WIFI_JOIN_APP_LIST_THRESHOLD" -> AND_WIFI_JOIN_APP_LIST_THRESHOLD =
                            nameValue.optLong("value")

                        "AND_INDOOR_DETECT_ENABLED" -> AND_INDOOR_DETECT_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_IN_APP_HISTOGRAM_ENABLED" -> AND_IN_APP_HISTOGRAM_ENABLED =
                            nameValue.optInt("value") == 1

                        "AND_REGISTER_RETRY_INTERVAL" -> AND_REGISTER_RETRY_INTERVAL =
                            nameValue.optLong("value")

                        "AND_CLEAR_NOTIFIED_WIFI_DURATION" -> AND_CLEAR_NOTIFIED_WIFI_DURATION =
                            nameValue.optLong("value")

                        "AND_CLEAR_NOTIFIED_WIFI_APP_DURATION" -> AND_CLEAR_NOTIFIED_WIFI_APP_DURATION =
                            nameValue.optLong("value")

                        "AND_CLEAR_NOTIFIED_ROAMING_DURATION" -> AND_CLEAR_NOTIFIED_ROAMING_DURATION =
                            nameValue.optLong("value")

                        "AND_CHECK_MASTER_INSTANCE_ALIVE" -> AND_CHECK_MASTER_INSTANCE_ALIVE =
                            nameValue.optLong("value")

                        "AND_APP_UPLOADER_DURATION" -> AND_APP_UPLOADER_DURATION =
                            nameValue.optLong("value")

                        "AND_SYSTEM_APP_UPLOADER_DURATION" -> AND_SYSTEM_APP_UPLOADER_DURATION =
                            nameValue.optLong("value")

                        "AND_DOWNLOAD_TEST_MAX_LIMIT" -> AND_DOWNLOAD_TEST_MAX_LIMIT =
                            nameValue.optLong("value")

                        "AND_UPLOAD_TEST_MAX_LIMIT" -> AND_UPLOAD_TEST_MAX_LIMIT =
                            nameValue.optLong("value")

                        "AND_LOCATION_INFO_UPLOAD_INTERVAL" -> AND_LOCATION_INFO_UPLOAD_INTERVAL =
                            nameValue.optLong("value")

                        "AND_LOCATION_INFO_UPLOAD_INTERVAL_PDU" -> AND_LOCATION_INFO_UPLOAD_INTERVAL_PDU =
                            nameValue.optLong("value")

                        "AND_LOCATION_INFO_UPLOAD_DISPLACEMENT" -> AND_LOCATION_INFO_UPLOAD_DISPLACEMENT =
                            nameValue.optLong("value")

                        "AND_LOCATION_INFO_UPLOAD_DISPLACEMENT_PDU" -> AND_LOCATION_INFO_UPLOAD_DISPLACEMENT_PDU =
                            nameValue.optLong("value")

                        /*"AND_LOCATION_ACCURACY" -> AND_LOCATION_ACCURACY =
                            nameValue.optInt("value")
                        "AND_LOCATION_ACCURACY_PDU" -> AND_LOCATION_ACCURACY_PDU =
                            nameValue.optInt("value")*/

                        "AND_DATA_COLLECTION_INTERVAL" -> AND_DATA_COLLECTION_INTERVAL =
                            nameValue.optInt("value")

                        "AND_DATA_COLLECTION_FLEX_INTERVAL" -> AND_DATA_COLLECTION_FLEX_INTERVAL =
                            nameValue.optInt("value")

                        "AND_IP_ACTIVITY_INTERVAL" -> AND_IP_ACTIVITY_INTERVAL =
                            nameValue.optInt("value")

                        "AND_IP_ACTIVITY_FLEX_INTERVAL" -> AND_IP_ACTIVITY_FLEX_INTERVAL =
                            nameValue.optInt("value")

                        "AND_BLE_DEVICES_INTERVAL" -> AND_BLE_DEVICES_INTERVAL =
                            nameValue.optInt("value")

                        "AND_BLE_DEVICES_FLEX_INTERVAL" -> AND_BLE_DEVICES_FLEX_INTERVAL =
                            nameValue.optInt("value")

                        else -> {}
                    }
                }
            } catch (e: Exception) {
                LOGE(TAG, "Exception in parseSettings", e)
                /*if (Utils.isDemo()) {
                    WorkerTable.insert(context, "Exception in parseSettings --> $e")
                }*/
                return false
            }
        } else {
            LOGE(TAG, "THE_CHECK 8")
            LOGD(TAG, "Parse Settings --> $settings")
            return false
        }
        return true
    }
}