package net.veloxity.sdk.hybrid_common

/**
 * Created by F.K. on 30.09.2023.
 *
 */
object Constants {
    val FILE_SDK by lazy { "VELOXITY_SDK" }
    val DEFAULT_SDK by lazy { "NedEn]16WLo9AqnR2GR1Q+X3LxO9Kc3CfDmGrYYB3vGRZw+h4=" }
    val FILE_COMMUNITY_INFO by lazy { "FILE_COMMUNITY_INFO" }
    val LICENSE_KEY by lazy { "veloxity_license_key" }
    val LICENSE_KEY_LIST by lazy { "veloxity_license_key_list" }
    val PACKAGE_NAME by lazy { "package_name" }
    val CONTENT_TYPE by lazy { "Content-Type" }
    val OCTET_STREAM by lazy { "application/octet-stream" }
    val CONTENT_ENCODING by lazy { "Content-Encoding" }
    val APPLICATION_GZIP by lazy { "application/gzip" }
    val ACCEPT_ENCODING by lazy { "accept-encoding" }
    val CONTENT_LENGTH by lazy { "Content-Length" }
    val APPLICATION_JSON by lazy { "application/json" }
    val MULTIPART by lazy { "multipart/form-data; boundary=" }
    val IF_NONE_MATCH by lazy { "If-None-Match" }
    val APP_STATE by lazy { "app_state" }
    val NOT_AVAILABLE by lazy { "N/A" }
    val PRIORITY_NOT_IN_RANGE by lazy {
        "Priority parameter should be in range [0-10000]. Please enter a valid priority."
    }
    val LICENSE_KEY_NOT_VALID by lazy {
        "Invalid license key. Please enter the correct license key or contact support@veloxity.net."
    }
    val FCM_SENDER_ID_EMPTY by lazy {
        "FCM Sender id key is null or empty. Please pass the correct fcm sender id."
    }
    val FCM_PROJECT_ID_EMPTY by lazy {
        "FCM Project id key is null or empty. Please pass the correct fcm project id."
    }
    val FCM_APP_ID_EMPTY by lazy {
        "FCM Application id key is null or empty. Please pass the correct fcm application id."
    }
    val FCM_API_KEY_EMPTY by lazy {
        "FCM API key is null or empty. Please pass the correct fcm api key."
    }
    val WEBSERVICE_ENDPOINT_EMPTY by lazy {
        "WebService Endpoint is null or empty. Please pass the correct webService endpoint key."
    }
    val WEBSERVICE_ENDPOINT_NOT_CONTAIN_FORWARD_SLASH_AT_THE_END by lazy {
        "WebService Endpoint does not contain forward slash at the end. WebService path must end with a forward slash at the end(xxx.xxx.net/)."
    }
    val WEBSERVICE_ENDPOINT_NOT_ABLE_TO_SET_ENDPOINT by lazy {
        "WebService Endpoint was not able to set correctly. Please connect with Veloxity representative."
    }
    val LICENSE_KEY_NOT_FOUND by lazy {
        "License key not found. In strings.xml, add the following element : <string name=\"veloxity_license_key\">your_license_key</string>"
    }
    val WIFI_QUALITY_NONE by lazy { "None" }
    val WIFI_QUALITY_LOW by lazy { "Low" }
    val WIFI_QUALITY_MEDIUM by lazy { "Medium" }
    val WIFI_QUALITY_HIGH by lazy { "High" }
    val WIFI_QUALITY_EXTREME by lazy { "Extreme" }
    val WIFI_CHANNEL_IS_GOOD by lazy { "You are good" }
    val NULL_SSID by lazy { "None" }
    val HEADER_ENC_KEY by lazy { "X-VLX-Ec" }
    val HEADER_ENC_VALUE by lazy { "utms247x38rb65j04ll6" }
    val HEADER_API_KEY by lazy { "X-Api-Key" }
    val FCM_DEVICE_TOKEN by lazy { "device_token" }
    val FCM_TOKEN by lazy { "gcm_token" }
    val FCM_SENDER_ID by lazy { "gcm_sender_id" }
    val FCM_PROJECT_ID by lazy { "fcm_project_id" }
    val FCM_APP_ID by lazy { "fcm_application_id" }
    val FCM_API_KEY by lazy { "fcm_api_key" }
    val PROMOTION_CHANNEL_NAME by lazy { "promotion_channel_name" }
    val APP_PREFIX by lazy { "app_prefix" }
    val APP_VSKOR_ENABLED by lazy { "app_vskor_enabled" }
    val GZIP by lazy { "gzip" }
    val EMPTY by lazy { "" }
    val BACKSLASH by lazy { "\"" }
    val SPACE by lazy { " " }
    val COLON by lazy { ":" }
    val UTF8 by lazy { "UTF-8" }
    val HTML_MIME_TYPE by lazy { "text/html" }
    val SPACE_CHAR by lazy { "\\s" }
    val LINE_END by lazy { "\n" }
    val ASTERISK by lazy { "*" }
    val PRIORITY by lazy { "KEY_MY_PRIORITY" }
    val APPLICATION_TRACKING_ENABLED by lazy { "KEY_APPLICATION_TRACKING_ENABLED" }

    val SDK_START by lazy { "net.veloxity.sdk.start" }
    val SERVICE_LIST by lazy { "veloxity_service_list" }
    val SERVICE_CHECK by lazy { "net.veloxity.sdk.SERVICE_CHECK" }
    val SERVICE_LIST_CHECK by lazy { "net.veloxity.sdk.SERVICE_LIST_CHECK" }
    val DISABLE by lazy { "net.veloxity.sdk.DISABLE" }
    val SHUTDOWN by lazy { "net.veloxity.sdk.SHUTDOWN" }
    val FOREGROUND_POSSIBLE by lazy { "net.veloxity.sdk.FOREGROUND_POSSIBLE" }
    val FOREGROUND_POSSIBLE_DATA by lazy { "NO_FOREGROUND" }
    val REALTIME_TRACKING_MODE by lazy { "net.veloxity.sdk.REALTIME_TRACKING_MODE" }
    val STOP_REALTIME_TRACKING_MODE by lazy { "net.veloxity.sdk.STOP_REALTIME_TRACKING_MODE" }
    val ACTION_MONITORING_MODE by lazy { "net.veloxity.sdk.ACTION_MONITORING_MODE" }
    val PN_TRIGGER_LOCATION by lazy { "net.veloxity.sdk.TRIGGER_LOCATION" }
    val PN_TRIGGER_PLAYLIST by lazy { "net.veloxity.sdk.TRIGGER_PLAYLIST" }
    val PN_TRIGGER_SETTINGS by lazy { "net.veloxity.sdk.TRIGGER_SETTINGS" }
    val PN_TRIGGER_RULES by lazy { "net.veloxity.sdk.TRIGGER_RULES" }
    val PN_TRIGGER_SENSORS by lazy { "net.veloxity.sdk.TRIGGER_SENSORS" }
    val WIFI_AP_STATE_CHANGED_ACTION by lazy { "android.net.wifi.WIFI_AP_STATE_CHANGED" }
    val PROMOTION_WIDGET by lazy { "net.veloxity.sdk.PROMOTION_WIDGET" }
    val VLX_PERMISSION by lazy { "net.veloxity.sdk.permission" }
    val DEVICE_STATE by lazy { "net.veloxity.sdk.vlx_device_state" }
    val ST_TEST by lazy { "net.veloxity.sdk.vlx_st_test" }

    val KEY_TOTAL_CONSUMPTION by lazy {  "TOTAL_CONSUMPTION" }
    val RESTART by lazy {  "restart" }
    val TRACKING_DURATION by lazy {  "tracking_duration" }
    val SHOW_DIALOG by lazy {  "showDialog" }
    val VLX_OPTIONS by lazy {  "vlxOptions" }
    val UPLOAD_URL by lazy {  "upload_url" }
    val MONITORING_MODE by lazy {  "monitoring_mode" }
    val TOTAL_UID by lazy {  -1 }
    val RESET_NOTIFIED_WIFI_BSSIDS by lazy {  0 }
    val RESET_NOTIFIED_WIFI_APP_BSSIDS by lazy {  1 }
    val RESET_NOTIFIED_ROAMING_OPERATORS by lazy {  2 }
    val RESET_MONITORING_MODE by lazy {  3 }
    val ALARM_RESET_TIME by lazy {  "alarm_reset_time" }
    val PERMISSION_ID by lazy {  "permission_id" }
    val ST_TEST_OBJ by lazy {  "vlx_st_obj" }
    val TRANSACTION_ID by lazy {  "vlx_transaction_id" }
    val VLX_FIRST_REG_DONE by lazy {  "vlx_first_register_done" }
    val ACTIVITY_ACTION by lazy {  "vlx_activity_action" }
    val ACTIVITY_DATA by lazy {  "vlx_activity_data" }
    val DELETE_INTENT by lazy {  "vlx_delete_intent" }
    val OK_INTENT by lazy {  "vlx_ok_intent" }
    val VLX_BUNDLE by lazy {  "vlx_bundle" }
    val TYPE_NONE by lazy {  "NONE" }
    val CHARGING_TYPE_AC by lazy {  "AC" }
    val CHARGING_TYPE_USB by lazy {  "USB" }
    val CHARGING_TYPE_WIRELESS by lazy {  "WIRELESS" }
    val DOCKING_TYPE_CAR by lazy {  "CAR" }
    val DOCKING_TYPE_DESK by lazy {  "DESK" }
    val DOCKING_TYPE_DESK_LE by lazy {  "DESK_ANALOG" }
    val DOCKING_TYPE_DESK_HE by lazy {  "DESK_DIGITAL" }
    val HUAWEI_ALLOWED_TO_RUN by lazy {  "device_allowed_to_run_vlx_sdk" }
    val HUAWEI_RANDOMIZED_VERSION_NAME by lazy {  "randomized_version_name" }
    val ALLOWED_PERCENTAGES_MAX by lazy {  10 }
    val ALLOWED_PERCENTAGES_MIN by lazy {  0 }
    val ACCESS_COARSE_LOCATION_PERMISSION_GRANTED by lazy {  "access_coarse_location_permission_granted" }
    val ACCESS_FINE_LOCATION_PERMISSION_GRANTED by lazy {  "access_fine_location_permission_granted" }

    val PUSH_NOTIFICATION_PAYLOAD_KEY by lazy {  "vlx_json_payload" }
    val PUSH_NOTIFICATION_FROM_PENDINGINTENT by lazy {  "push_notification_from_pending_intent" }
    val PREV_APP_UPLOAD_TIME_SYSTEM by lazy {  "prev_app_upload_time_system" }
    val PREV_APP_UPLOAD_TIME_USER by lazy {  "prev_app_upload_time_user" }

    val REGISTER_SERVICE_DATE by lazy {  "VLX_REGISTER_SERVICE_DATE" }
    val REGISTER_PUSH_SERVICE_DATE by lazy {  "VLX_REGISTER_PUSH_SERVICE_DATE" }
    val DELAY_SERVICE_DATE by lazy {  "VLX_DELAY_SERVICE_DATE" }
    val DELAY_SERVICE_NUMBER_OF_DAYS by lazy {  "VLX_DELAY_SERVICE_NUMBER_OF_DAYS" }
    val DELAY_SERVICE_DEFAULT_NUMBER_OF_DAYS by lazy {  3 }

    val PAIRED_DEVICES_DATE by lazy {  "PAIRED_DEVICES_DATE" }
    val BLE_DEVICES_WORK by lazy {  "BLE_DEVICES_WORK_MANAGER" }
    val IP_ACTIVITY_WORK by lazy {  "IP_ACTIVITY_WORK_MANAGER" }

    val VSKOR_DEFAULT by lazy {  1 }
    val CONFIDENCE_LEVEL_DEFAULT by lazy {  0.0 }
    val RISK_CLASS_DEFAULT by lazy {  "V8" }
}