package net.veloxity.sdk.hybrid_common

import android.util.Log

/**
 * Created by F.K. on 1.10.2023.
 *
 */
object LogUtils {
    private val LOG_PREFIX by lazy { "VLX_" }
    private val LOG_PREFIX_LENGTH by lazy { LOG_PREFIX.length }
    private val MAX_LOG_TAG_LENGTH by lazy { 23 }

    fun makeLogTag(str: String): String {
        return if (str.length > MAX_LOG_TAG_LENGTH - LOG_PREFIX_LENGTH) {
            LOG_PREFIX + str.substring(0, MAX_LOG_TAG_LENGTH - LOG_PREFIX_LENGTH - 1)
        } else LOG_PREFIX + str
    }

    fun makeLogTag(cls: Class<*>): String? {
        return makeLogTag(cls.simpleName)
    }

    fun LOGD(tag: String?, message: String?) {
        if (BuildConfig.DEBUG|| Log.isLoggable(tag, Log.DEBUG)) {
            Log.d(tag, message!!)
        }
    }

    fun LOGD(tag: String?, message: String, message2: String) {
        if (BuildConfig.DEBUG || Log.isLoggable(tag, Log.DEBUG)) {
            Log.d(tag, message + message2)
        }
    }

    fun LOGD(tag: String?, message: String, message2: String, message3: String) {
        if (BuildConfig.DEBUG || Log.isLoggable(tag, Log.DEBUG)) {
            Log.d(tag, message + message2 + message3)
        }
    }

    fun LOGD(tag: String?, message: String?, cause: Throwable?) {
        if (BuildConfig.DEBUG || Log.isLoggable(tag, Log.DEBUG)) {
            Log.d(tag, message, cause)
        }
    }

    fun LOGV(tag: String?, message: String?) {
        if (BuildConfig.DEBUG || Log.isLoggable(tag, Log.VERBOSE)) {
            Log.v(tag, message!!)
        }
    }

    fun LOGV(tag: String?, message: String, message2: String) {
        if (BuildConfig.DEBUG || Log.isLoggable(tag, Log.VERBOSE)) {
            Log.v(tag, message + message2)
        }
    }

    fun LOGV(tag: String?, message: String?, cause: Throwable?) {
        if (BuildConfig.DEBUG || Log.isLoggable(tag, Log.VERBOSE)) {
            Log.v(tag, message, cause)
        }
    }

    fun LOGI(tag: String?, message: String?) {
        if (BuildConfig.DEBUG && Log.isLoggable(tag, Log.INFO)) {
            Log.i(tag, message!!)
        }
    }

    fun LOGI(tag: String?, message: String, message2: String) {
        if (BuildConfig.DEBUG || Log.isLoggable(tag, Log.DEBUG)) {
            Log.d(tag, message + message2)
        }
    }

    fun LOGI(tag: String?, message: String, message2: String, message3: String, message4: String) {
        if (BuildConfig.DEBUG || Log.isLoggable(tag, Log.DEBUG)) {
            Log.d(tag, message + message2 + message3 + message4)
        }
    }

    fun LOGI(
        tag: String?,
        message: String,
        message2: String,
        message3: String,
        message4: String,
        message5: String
    ) {
        if (BuildConfig.DEBUG || Log.isLoggable(tag, Log.DEBUG)) {
            Log.d(tag, message + message2 + message3 + message4 + message5)
        }
    }

    fun LOGI(tag: String?, message: String?, cause: Throwable?) {
        if (BuildConfig.DEBUG && Log.isLoggable(tag, Log.INFO)) {
            Log.i(tag, message, cause)
        }
    }

    fun LOGW(tag: String?, message: String?) {
        if (BuildConfig.DEBUG && Log.isLoggable(tag, Log.WARN)) {
            Log.w(tag, message!!)
        }
    }

    fun LOGW(tag: String?, message: String?, cause: Throwable?) {
        if (BuildConfig.DEBUG && Log.isLoggable(tag, Log.WARN)) {
            Log.w(tag, message, cause)
        }
    }

    fun LOGE(tag: String?, message: String?) {
        if (BuildConfig.DEBUG && Log.isLoggable(tag, Log.ERROR)) {
            Log.e(tag, message!!)
        }
    }

    fun LOGE(tag: String?, message: String, message2: String) {
        if (BuildConfig.DEBUG && Log.isLoggable(tag, Log.ERROR)) {
            Log.e(tag, message + message2)
        }
    }

    fun LOGE(tag: String?, message: String?, cause: Throwable?) {
        if (BuildConfig.DEBUG && Log.isLoggable(tag, Log.ERROR)) {
            Log.e(tag, message, cause)
        }
    }
}