/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.core.config;

import java.nio.charset.StandardCharsets;
import net.wenzuo.atom.core.properties.CoreRestTemplateProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

@ConditionalOnProperty(value={"atom.core.rest-template"}, matchIfMissing=true)
@Configuration
public class CoreRestTemplateConfig {
    private static final Logger log = LoggerFactory.getLogger(CoreRestTemplateConfig.class);
    private final CoreRestTemplateProperties coreRestTemplateProperties;

    @ConditionalOnMissingBean
    @Bean
    public RestTemplate restTemplate(ClientHttpRequestFactory factory) {
        RestTemplate restTemplate = new RestTemplate(factory);
        restTemplate.getMessageConverters().add(0, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        return restTemplate;
    }

    @ConditionalOnMissingBean
    @Bean
    public ClientHttpRequestFactory clientHttpRequestFactory() {
        OkHttp3ClientHttpRequestFactory factory = new OkHttp3ClientHttpRequestFactory();
        factory.setConnectTimeout(this.coreRestTemplateProperties.getConnectTimeout());
        factory.setReadTimeout(this.coreRestTemplateProperties.getReadTimeout());
        factory.setWriteTimeout(this.coreRestTemplateProperties.getWriteTimeout());
        return factory;
    }

    public CoreRestTemplateConfig(CoreRestTemplateProperties coreRestTemplateProperties) {
        this.coreRestTemplateProperties = coreRestTemplateProperties;
    }
}

