/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.core.util;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.DesensitizedUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;
import net.wenzuo.atom.core.util.Desensitization;
import net.wenzuo.atom.core.util.DesensitizationType;

public class DesensitizationSerialize
extends JsonSerializer<Object>
implements ContextualSerializer {
    private DesensitizationType type;
    private Integer start;
    private Integer end;

    public void serialize(Object value, JsonGenerator jsonGenerator, SerializerProvider serializers) throws IOException {
        if (value == null) {
            return;
        }
        switch (this.type) {
            case CUSTOM: {
                jsonGenerator.writeString(CharSequenceUtil.hide((CharSequence)value.toString(), (int)this.start, (int)this.end));
                break;
            }
            case USER_ID: {
                if (value instanceof Number) {
                    jsonGenerator.writeNumber(String.valueOf(DesensitizedUtil.userId()));
                    break;
                }
                jsonGenerator.writeString(String.valueOf(DesensitizedUtil.userId()));
                break;
            }
            case CHINESE_NAME: {
                jsonGenerator.writeString(DesensitizedUtil.chineseName((String)value.toString()));
                break;
            }
            case ID_CARD: {
                jsonGenerator.writeString(DesensitizedUtil.idCardNum((String)value.toString(), (int)1, (int)2));
                break;
            }
            case MOBILE_PHONE: {
                jsonGenerator.writeString(DesensitizedUtil.mobilePhone((String)value.toString()));
                break;
            }
            case FIXED_PHONE: {
                jsonGenerator.writeString(DesensitizedUtil.fixedPhone((String)value.toString()));
                break;
            }
            case ADDRESS: {
                jsonGenerator.writeString(DesensitizedUtil.address((String)value.toString(), (int)8));
                break;
            }
            case EMAIL: {
                jsonGenerator.writeString(DesensitizedUtil.email((String)value.toString()));
                break;
            }
            case PASSWORD: {
                jsonGenerator.writeString(DesensitizedUtil.password((String)value.toString()));
                break;
            }
            case BANK_CARD: {
                jsonGenerator.writeString(DesensitizedUtil.bankCard((String)value.toString()));
                break;
            }
            case CAR_LICENSE: {
                jsonGenerator.writeString(DesensitizedUtil.carLicense((String)value.toString()));
                break;
            }
        }
    }

    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        if (beanProperty == null) {
            return serializerProvider.findNullValueSerializer(null);
        }
        Desensitization desensitization = (Desensitization)beanProperty.getAnnotation(Desensitization.class);
        if (desensitization == null) {
            desensitization = (Desensitization)beanProperty.getContextAnnotation(Desensitization.class);
        }
        if (desensitization != null) {
            return new DesensitizationSerialize(desensitization.type(), desensitization.start(), desensitization.end());
        }
        return serializerProvider.findValueSerializer(beanProperty.getType(), beanProperty);
    }

    public DesensitizationSerialize(DesensitizationType type, Integer start, Integer end) {
        this.type = type;
        this.start = start;
        this.end = end;
    }

    public DesensitizationSerialize() {
    }
}

