/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.core.util;

import java.util.Comparator;

public class NaturalComparator
implements Comparator<String> {
    private static boolean isDigit(String str) {
        char ch = str.charAt(0);
        return ch >= '0' && ch <= '9';
    }

    static String nextSlice(String str, int index) {
        int length = str.length();
        if (index == length) {
            return null;
        }
        char ch = str.charAt(index);
        if (ch == '.' || ch == ' ') {
            return str.substring(index, index + 1);
        }
        if (ch >= '0' && ch <= '9') {
            return str.substring(index, NaturalComparator.nextNumberBound(str, index + 1));
        }
        return str.substring(index, NaturalComparator.nextOtherBound(str, index + 1));
    }

    private static int nextNumberBound(String str, int index) {
        char ch;
        int length = str.length();
        while (index < length && (ch = str.charAt(index)) >= '0' && ch <= '9') {
            ++index;
        }
        return index;
    }

    private static int nextOtherBound(String str, int index) {
        char ch;
        int length = str.length();
        while (index < length && (ch = str.charAt(index)) != '.' && ch != ' ' && (ch < '0' || ch > '9')) {
            ++index;
        }
        return index;
    }

    @Override
    public int compare(String o1, String o2) {
        int result;
        int index1 = 0;
        int index2 = 0;
        do {
            String data1 = NaturalComparator.nextSlice(o1, index1);
            String data2 = NaturalComparator.nextSlice(o2, index2);
            if (data1 == null && data2 == null) {
                return 0;
            }
            if (data1 == null) {
                return -1;
            }
            if (data2 == null) {
                return 1;
            }
            index1 += data1.length();
            index2 += data2.length();
            if (NaturalComparator.isDigit(data1) && NaturalComparator.isDigit(data2)) {
                result = Long.compare(Long.parseLong(data1), Long.parseLong(data2));
                if (result != 0) continue;
                result = -Integer.compare(data1.length(), data2.length());
                continue;
            }
            result = data1.compareToIgnoreCase(data2);
        } while (result == 0);
        return result;
    }
}

