/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.core.util;

import net.wenzuo.atom.core.util.ResultProvider;

public class Result<T>
implements ResultProvider {
    private static final int OK_CODE = 200;
    private static final String OK_MESSAGE = "\u6210\u529f";
    private int code;
    private String message;
    private T data;

    public static <T> Result<T> ok() {
        return new Result<Object>(200, OK_MESSAGE, null);
    }

    public static <T> Result<T> ok(T data) {
        return new Result<T>(200, OK_MESSAGE, data);
    }

    public static <T> Result<T> fail(int code, String message) {
        return new Result<Object>(code, message, null);
    }

    public static <T> Result<T> fail(ResultProvider provider) {
        return new Result<Object>(provider.getCode(), provider.getMessage(), null);
    }

    public Result(int code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public Result() {
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Result(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }
}

