/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.core.config;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.Generated;
import net.wenzuo.atom.core.util.JsonUtils;
import net.wenzuo.atom.core.util.NanoIdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.task.TaskExecutionProperties;
import org.springframework.boot.task.ThreadPoolTaskExecutorBuilder;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskDecorator;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@EnableAsync
@ConditionalOnProperty(value={"atom.core.async"}, matchIfMissing=true)
@Configuration
public class CoreAsyncConfiguration
implements AsyncConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CoreAsyncConfiguration.class);
    private final TaskExecutionProperties taskExecutionProperties;

    public Executor getAsyncExecutor() {
        TaskExecutionProperties.Pool pool = this.taskExecutionProperties.getPool();
        TaskExecutionProperties.Shutdown shutdown = this.taskExecutionProperties.getShutdown();
        TaskDecorator taskDecorator = runnable -> {
            Map contextMap = MDC.getCopyOfContextMap();
            HashMap<String, String> ctxMap = new HashMap<String, String>(contextMap);
            if (!ctxMap.containsKey("Trace-Id")) {
                String traceId = NanoIdUtils.nanoId();
                ctxMap.put("Trace-Id", traceId);
            }
            return () -> {
                try {
                    MDC.setContextMap((Map)ctxMap);
                    runnable.run();
                }
                finally {
                    MDC.clear();
                }
            };
        };
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutorBuilder().queueCapacity(pool.getQueueCapacity()).corePoolSize(pool.getCoreSize()).maxPoolSize(pool.getMaxSize()).allowCoreThreadTimeOut(pool.isAllowCoreThreadTimeout()).keepAlive(pool.getKeepAlive()).awaitTermination(shutdown.isAwaitTermination()).awaitTerminationPeriod(shutdown.getAwaitTerminationPeriod()).threadNamePrefix(this.taskExecutionProperties.getThreadNamePrefix()).taskDecorator(taskDecorator).build();
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return executor;
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return (t, method, params) -> log.error("Async exception: " + t.getMessage() + ", method: " + method.getName() + ", params: " + JsonUtils.toJson(params), t);
    }

    @Generated
    public CoreAsyncConfiguration(TaskExecutionProperties taskExecutionProperties) {
        this.taskExecutionProperties = taskExecutionProperties;
    }
}

