/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.core.util.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import java.io.IOException;
import java.math.BigDecimal;

@JacksonStdImpl
public class BigDecimalDeserializer
extends JsonDeserializer<BigDecimal> {
    public static final BigDecimalDeserializer instance = new BigDecimalDeserializer();

    public BigDecimal deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
        String value = parser.getText();
        if (value == null || value.isEmpty()) {
            return null;
        }
        JsonToken token = parser.getCurrentToken();
        if (token.isBoolean()) {
            return parser.getBooleanValue() ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        value = value.trim();
        return new BigDecimal(value);
    }
}

