/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.core.util.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import net.wenzuo.atom.core.util.json.JsonDecimalFormat;

@JacksonStdImpl
public class BigDecimalSerializer
extends JsonSerializer<BigDecimal>
implements ContextualSerializer {
    public static final BigDecimalSerializer instance = new BigDecimalSerializer();
    private DecimalFormat decimalFormat;

    public BigDecimalSerializer() {
    }

    public BigDecimalSerializer(String pattern, RoundingMode roundingMode) {
        this.decimalFormat = new DecimalFormat(pattern);
        this.decimalFormat.setRoundingMode(roundingMode);
    }

    public void serialize(BigDecimal value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this.decimalFormat == null) {
            gen.writeString(value.toPlainString());
            return;
        }
        gen.writeString(this.decimalFormat.format(value));
    }

    public void serializeWithType(BigDecimal value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId((Object)value, JsonToken.VALUE_STRING));
        this.serialize(value, gen, serializers);
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        if (property == null) {
            return provider.findNullValueSerializer(null);
        }
        JsonDecimalFormat annotation = (JsonDecimalFormat)property.getAnnotation(JsonDecimalFormat.class);
        if (annotation == null) {
            annotation = (JsonDecimalFormat)property.getContextAnnotation(JsonDecimalFormat.class);
        }
        if (annotation == null) {
            return instance;
        }
        return new BigDecimalSerializer(annotation.value(), annotation.roundingMode());
    }
}

