/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.core.util.json;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.DesensitizedUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;
import lombok.Generated;
import net.wenzuo.atom.core.util.DesensitizationType;
import net.wenzuo.atom.core.util.json.JsonDesensitization;

public class DesensitizationSerializer
extends JsonSerializer<Object>
implements ContextualSerializer {
    private DesensitizationType type;
    private Integer start;
    private Integer end;

    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (value == null) {
            return;
        }
        if (value.toString().isEmpty()) {
            gen.writeString("");
            return;
        }
        switch (this.type) {
            case CUSTOM: {
                gen.writeString(CharSequenceUtil.hide((CharSequence)value.toString(), (int)this.start, (int)this.end));
                break;
            }
            case USER_ID: {
                if (value instanceof Number) {
                    gen.writeNumber(String.valueOf(DesensitizedUtil.userId()));
                    break;
                }
                gen.writeString(String.valueOf(DesensitizedUtil.userId()));
                break;
            }
            case CHINESE_NAME: {
                gen.writeString(DesensitizedUtil.chineseName((String)value.toString()));
                break;
            }
            case ID_CARD: {
                gen.writeString(DesensitizedUtil.idCardNum((String)value.toString(), (int)3, (int)4));
                break;
            }
            case MOBILE_PHONE: {
                gen.writeString(DesensitizedUtil.mobilePhone((String)value.toString()));
                break;
            }
            case FIXED_PHONE: {
                gen.writeString(DesensitizedUtil.fixedPhone((String)value.toString()));
                break;
            }
            case ADDRESS: {
                gen.writeString(DesensitizedUtil.address((String)value.toString(), (int)6));
                break;
            }
            case EMAIL: {
                gen.writeString(DesensitizedUtil.email((String)value.toString()));
                break;
            }
            case PASSWORD: {
                gen.writeString(DesensitizedUtil.password((String)value.toString()));
                break;
            }
            case BANK_CARD: {
                gen.writeString(DesensitizedUtil.bankCard((String)value.toString()));
                break;
            }
            case CAR_LICENSE: {
                gen.writeString(DesensitizedUtil.carLicense((String)value.toString()));
                break;
            }
            case IPV4: {
                gen.writeString(DesensitizedUtil.ipv4((String)value.toString()));
                break;
            }
            case IPV6: {
                gen.writeString(DesensitizedUtil.ipv6((String)value.toString()));
                break;
            }
        }
    }

    public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId(value, JsonToken.VALUE_STRING));
        this.serialize(value, gen, serializers);
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        if (property == null) {
            return provider.findNullValueSerializer(null);
        }
        JsonDesensitization annotation = (JsonDesensitization)property.getAnnotation(JsonDesensitization.class);
        if (annotation == null) {
            annotation = (JsonDesensitization)property.getContextAnnotation(JsonDesensitization.class);
        }
        if (annotation != null) {
            return new DesensitizationSerializer(annotation.value(), annotation.start(), annotation.end());
        }
        return provider.findValueSerializer(property.getType(), property);
    }

    @Generated
    public DesensitizationSerializer(DesensitizationType type, Integer start, Integer end) {
        this.type = type;
        this.start = start;
        this.end = end;
    }

    @Generated
    public DesensitizationSerializer() {
    }
}

