/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.core.util.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import java.io.IOException;

@JacksonStdImpl
public class LongDeserializer
extends JsonDeserializer<Long> {
    public static final LongDeserializer instance = new LongDeserializer();

    public Long deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
        String value = parser.getText();
        if (value == null || value.isEmpty()) {
            return null;
        }
        JsonToken token = parser.getCurrentToken();
        if (token.isBoolean()) {
            return parser.getBooleanValue() ? 1L : 0L;
        }
        value = value.trim();
        return Long.parseLong(value);
    }
}

