/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.mqtt;

import java.util.Arrays;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.springframework.util.Assert;

public class MqttConsumer {
    private String id;
    private String[] topics;
    private int[] qos;
    private BiConsumer<String, String> consumer;

    public MqttConsumer() {
    }

    public MqttConsumer(String id, String[] topics, int[] qos, BiConsumer<String, String> consumer) {
        this.id = id;
        this.topics = topics;
        this.qos = qos;
        this.consumer = consumer;
    }

    public void initialize() {
        this.check();
        this.alignLength();
    }

    public void check() {
        Assert.notNull((Object)this.id, (String)"MQTT id must not be null");
        Assert.notEmpty((Object[])this.topics, (String)"MQTT topics must not be empty");
        Assert.isTrue((this.qos != null && this.qos.length > 0 ? 1 : 0) != 0, (String)"MQTT qos must not be empty");
    }

    public void alignLength() {
        if (this.qos.length == this.topics.length) {
            return;
        }
        if (this.qos.length == 1) {
            int[] targetQos = new int[this.topics.length];
            Arrays.fill(targetQos, this.qos[0]);
            this.qos = targetQos;
            return;
        }
        throw new RuntimeException("MQTT qos length must be 1 or equal to topics length");
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String[] getTopics() {
        return this.topics;
    }

    @Generated
    public int[] getQos() {
        return this.qos;
    }

    @Generated
    public BiConsumer<String, String> getConsumer() {
        return this.consumer;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setTopics(String[] topics) {
        this.topics = topics;
    }

    @Generated
    public void setQos(int[] qos) {
        this.qos = qos;
    }

    @Generated
    public void setConsumer(BiConsumer<String, String> consumer) {
        this.consumer = consumer;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MqttConsumer)) {
            return false;
        }
        MqttConsumer other = (MqttConsumer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTopics(), other.getTopics())) {
            return false;
        }
        if (!Arrays.equals(this.getQos(), other.getQos())) {
            return false;
        }
        BiConsumer<String, String> this$consumer = this.getConsumer();
        BiConsumer<String, String> other$consumer = other.getConsumer();
        return !(this$consumer == null ? other$consumer != null : !this$consumer.equals(other$consumer));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MqttConsumer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTopics());
        result = result * 59 + Arrays.hashCode(this.getQos());
        BiConsumer<String, String> $consumer = this.getConsumer();
        result = result * 59 + ($consumer == null ? 43 : $consumer.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MqttConsumer(id=" + this.getId() + ", topics=" + Arrays.deepToString(this.getTopics()) + ", qos=" + Arrays.toString(this.getQos()) + ", consumer=" + this.getConsumer() + ")";
    }
}

