/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.mqtt;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import net.wenzuo.atom.mqtt.MqttConsumer;
import net.wenzuo.atom.mqtt.MqttListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.NonNull;
import org.springframework.util.ReflectionUtils;

public class MqttListenerProcessor
implements BeanPostProcessor,
Ordered {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MqttListenerProcessor.class);
    private final List<MqttConsumer> consumers;
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));

    public MqttListenerProcessor() {
        this.consumers = new ArrayList<MqttConsumer>();
    }

    public Object postProcessBeforeInitialization(@NonNull Object bean, @NonNull String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(@NonNull Object bean, @NonNull String beanName) throws BeansException {
        if (this.nonAnnotatedClasses.contains(bean.getClass())) {
            return bean;
        }
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        Map annotatedMethods = MethodIntrospector.selectMethods((Class)targetClass, method -> (MqttListener)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, MqttListener.class));
        if (annotatedMethods.isEmpty()) {
            return bean;
        }
        for (Map.Entry entry : annotatedMethods.entrySet()) {
            Method method2 = (Method)entry.getKey();
            MqttListener listener = (MqttListener)entry.getValue();
            Method methodToUse = this.checkProxy(method2, bean);
            MqttConsumer consumer = new MqttConsumer(listener.id(), listener.topics(), listener.qos(), (topic, value) -> {
                try {
                    methodToUse.invoke(bean, topic, value);
                }
                catch (Exception e) {
                    log.error("MQTT invoke error", (Throwable)e);
                }
            });
            this.consumers.add(consumer);
        }
        if (log.isDebugEnabled()) {
            log.debug("{} @MqttListener methods processed on bean '{}': {}", new Object[]{annotatedMethods.size(), beanName, annotatedMethods});
        }
        return bean;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    private Method checkProxy(Method methodArg, Object bean) {
        Method method = methodArg;
        if (AopUtils.isJdkDynamicProxy((Object)bean)) {
            try {
                Class[] proxiedInterfaces;
                method = bean.getClass().getMethod(method.getName(), method.getParameterTypes());
                for (Class iface : proxiedInterfaces = ((Advised)bean).getProxiedInterfaces()) {
                    try {
                        method = iface.getMethod(method.getName(), method.getParameterTypes());
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
            }
            catch (SecurityException ex) {
                ReflectionUtils.handleReflectionException((Exception)ex);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException(String.format("@MqttListener method '%s' found on bean target class '%s', but not found in any interface(s) for bean JDK proxy. Either pull the method up to an interface or switch to subclass (CGLIB) proxies by setting proxy-target-class/proxyTargetClass attribute to 'true'", method.getName(), method.getDeclaringClass().getSimpleName()), ex);
            }
        }
        return method;
    }

    @Generated
    public List<MqttConsumer> getConsumers() {
        return this.consumers;
    }

    @Generated
    public Set<Class<?>> getNonAnnotatedClasses() {
        return this.nonAnnotatedClasses;
    }
}

