/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.mqtt;

import java.nio.charset.StandardCharsets;
import lombok.Generated;
import net.wenzuo.atom.mqtt.MqttService;
import net.wenzuo.atom.mqtt.config.MqttProperties;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class MqttServiceImpl
implements MqttService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MqttServiceImpl.class);
    public static final int DEFAULT_QOS = 1;
    public static final boolean DEFAULT_RETAINED = false;
    private final ApplicationContext applicationContext;
    private final MqttProperties mqttProperties;

    @Override
    public void send(String topic, String message) {
        this.send(this.mqttProperties.getId(), topic, message, 1, false);
    }

    @Override
    public void send(String topic, String message, int qos) {
        this.send(this.mqttProperties.getId(), topic, message, qos, false);
    }

    @Override
    public void send(String topic, String message, boolean retained) {
        this.send(this.mqttProperties.getId(), topic, message, 1, retained);
    }

    @Override
    public void send(String topic, String message, int qos, boolean retained) {
        this.send(this.mqttProperties.getId(), topic, message, qos, retained);
    }

    @Override
    public void send(String id, String topic, String message) {
        this.send(id, topic, message, 1, false);
    }

    @Override
    public void send(String id, String topic, String message, int qos) {
        this.send(id, topic, message, qos, false);
    }

    @Override
    public void send(String id, String topic, String message, boolean retained) {
        this.send(id, topic, message, 1, retained);
    }

    @Override
    public void send(String id, String topic, String message, int qos, boolean retained) {
        if (log.isDebugEnabled()) {
            log.debug("MQTT send: id={}, topic={}, qos: {}, retained: {}, message={}", new Object[]{id, topic, qos, retained, message});
        }
        try {
            Object mqttClient = this.applicationContext.getBean("mqttClient-" + id);
            String className = mqttClient.getClass().getName();
            if ("org.eclipse.paho.mqttv5.client.MqttClient".equals(className)) {
                ((MqttClient)mqttClient).publish(topic, message.getBytes(StandardCharsets.UTF_8), qos, retained);
                return;
            }
            if ("org.eclipse.paho.client.mqttv3.MqttClient".equals(className)) {
                ((org.eclipse.paho.client.mqttv3.MqttClient)mqttClient).publish(topic, message.getBytes(StandardCharsets.UTF_8), qos, retained);
                return;
            }
            throw new RuntimeException("MQTT client not supported: " + className);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public MqttServiceImpl(ApplicationContext applicationContext, MqttProperties mqttProperties) {
        this.applicationContext = applicationContext;
        this.mqttProperties = mqttProperties;
    }
}

