/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.web.config;

import net.wenzuo.atom.web.properties.CorsProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@ConditionalOnProperty(value={"atom.web.cors.enabled"}, matchIfMissing=true)
@Configuration
public class CorsConfiguration {
    private final CorsProperties corsProperties;

    @Bean
    @ConditionalOnMissingBean
    public CorsFilter corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        for (CorsProperties.Config config : this.corsProperties.getConfigs()) {
            org.springframework.web.cors.CorsConfiguration corsConfig = new org.springframework.web.cors.CorsConfiguration();
            corsConfig.setAllowCredentials(config.getAllowCredentials());
            corsConfig.setAllowedOrigins(config.getAllowedOrigins());
            corsConfig.setAllowedOriginPatterns(config.getAllowedOriginPatterns());
            corsConfig.setAllowedHeaders(config.getAllowedHeaders());
            corsConfig.setAllowedMethods(config.getAllowedMethods());
            corsConfig.setExposedHeaders(config.getExposedHeaders());
            source.registerCorsConfiguration(config.getPattern(), corsConfig);
        }
        return new CorsFilter((CorsConfigurationSource)source);
    }

    public CorsConfiguration(CorsProperties corsProperties) {
        this.corsProperties = corsProperties;
    }
}

