/*
 * Decompiled with CFR 0.152.
 */
package net.wenzuo.atom.web.config;

import jakarta.annotation.Resource;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.wenzuo.atom.core.util.NanoIdUtils;
import net.wenzuo.atom.web.config.CachedRequestWrapper;
import net.wenzuo.atom.web.config.CachedResponseWrapper;
import net.wenzuo.atom.web.properties.LoggingProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.util.StreamUtils;
import org.springframework.web.filter.OncePerRequestFilter;

@ConditionalOnProperty(value={"atom.web.logging.enabled"}, matchIfMissing=true)
@Order(value=-50)
@Component
public class LoggingFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(LoggingFilter.class);
    private static final ThreadLocal<Long> TIMER = new ThreadLocal();
    private static final String REQ_ID = "Req-Id";
    private static final PathMatcher PATH_MATCHER = new AntPathMatcher();
    @Resource
    private LoggingProperties loggingProperties;
    @Value(value="${server.servlet.context-path:}")
    private String contextPath;
    @Value(value="${spring.mvc.servlet.path:}")
    private String servletPath;

    protected boolean shouldNotFilter(@NonNull HttpServletRequest request) throws ServletException {
        if (!log.isInfoEnabled()) {
            return true;
        }
        String uri = request.getRequestURI().substring(this.contextPath.length() + this.servletPath.length());
        for (String path : this.loggingProperties.getInternalExcludePath()) {
            if (!PATH_MATCHER.match(path, uri)) continue;
            return true;
        }
        for (String path : this.loggingProperties.getExcludePath()) {
            if (!PATH_MATCHER.match(path, uri)) continue;
            return true;
        }
        for (String path : this.loggingProperties.getIncludePath()) {
            if (!PATH_MATCHER.match(path, uri)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        TIMER.set(System.currentTimeMillis());
        String reqId = NanoIdUtils.nanoId();
        response.setHeader(REQ_ID, reqId);
        MDC.put((String)REQ_ID, (String)reqId);
        CachedRequestWrapper requestToUse = request instanceof CachedRequestWrapper ? (CachedRequestWrapper)request : new CachedRequestWrapper(request);
        CachedResponseWrapper responseToUse = response instanceof CachedResponseWrapper ? (CachedResponseWrapper)response : new CachedResponseWrapper(response);
        this.loggingRequest(requestToUse);
        try {
            filterChain.doFilter((ServletRequest)requestToUse, (ServletResponse)responseToUse);
        }
        finally {
            this.loggingResponse(responseToUse);
            TIMER.remove();
            MDC.remove((String)REQ_ID);
        }
    }

    private void loggingRequest(CachedRequestWrapper wrapper) throws IOException {
        StringBuilder msg = new StringBuilder();
        msg.append("REQUEST: ").append(wrapper.getMethod()).append(' ').append(wrapper.getRequestURI());
        String queryString = wrapper.getQueryString();
        if (queryString != null) {
            msg.append('?').append(URLDecoder.decode(queryString, StandardCharsets.UTF_8));
        }
        if (this.isReadable(wrapper)) {
            String payload;
            try (ServletInputStream inputStream = wrapper.getInputStream();){
                payload = StreamUtils.copyToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            }
            if (payload.length() == 0) {
                Map form = wrapper.getParameterMap();
                StringBuilder param = new StringBuilder();
                Iterator nameIterator = form.keySet().iterator();
                while (nameIterator.hasNext()) {
                    String name = (String)nameIterator.next();
                    List<String> values = Arrays.asList((String[])form.get(name));
                    Iterator<String> valueIterator = values.iterator();
                    while (valueIterator.hasNext()) {
                        String value = valueIterator.next();
                        param.append(name);
                        if (value == null) continue;
                        param.append('=').append(value);
                        if (!valueIterator.hasNext()) continue;
                        param.append('&');
                    }
                    if (!nameIterator.hasNext()) continue;
                    param.append('&');
                }
                payload = param.toString();
            }
            if (payload.length() > 0) {
                msg.append(' ').append(payload);
            }
        }
        log.info(msg.toString());
    }

    private void loggingResponse(CachedResponseWrapper wrapper) throws IOException {
        StringBuilder msg = new StringBuilder();
        long time = System.currentTimeMillis() - TIMER.get();
        msg.append("RESPONSE: ").append(time).append("ms");
        msg.append(' ').append(wrapper.getStatus());
        if (this.isReadable(wrapper)) {
            String payload;
            try (InputStream is = wrapper.getContentInputStream();){
                payload = StreamUtils.copyToString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            }
            if (payload.length() > 0) {
                msg.append(' ').append(payload);
            }
        }
        wrapper.copyBodyToResponse();
        log.info(msg.toString());
    }

    private boolean isReadable(CachedRequestWrapper wrapper) {
        String contentType = wrapper.getContentType();
        if (contentType == null) {
            return false;
        }
        return !contentType.contains("multipart/form-data");
    }

    private boolean isReadable(CachedResponseWrapper wrapper) {
        if (wrapper.getStatus() != HttpStatus.OK.value()) {
            return true;
        }
        String contentType = wrapper.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.contains("application/json") || contentType.contains("application/xml") || contentType.contains("text/plain") || contentType.contains("text/html") || contentType.contains("text/xml");
    }
}

